/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfp.axis.v201502;

import com.google.api.ads.dfp.axis.v201502.PackageService;
import com.google.api.ads.dfp.axis.v201502.PackageServiceInterface;
import com.google.api.ads.dfp.axis.v201502.PackageServiceSoapBindingStub;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;

public class PackageServiceLocator
extends Service
implements PackageService {
    private String PackageServiceInterfacePort_address = "https://ads.google.com/apis/ads/publisher/v201502/PackageService";
    private String PackageServiceInterfacePortWSDDServiceName = "PackageServiceInterfacePort";
    private HashSet ports = null;

    public PackageServiceLocator() {
    }

    public PackageServiceLocator(EngineConfiguration config) {
        super(config);
    }

    public PackageServiceLocator(String wsdlLoc, QName sName) throws ServiceException {
        super(wsdlLoc, sName);
    }

    @Override
    public String getPackageServiceInterfacePortAddress() {
        return this.PackageServiceInterfacePort_address;
    }

    public String getPackageServiceInterfacePortWSDDServiceName() {
        return this.PackageServiceInterfacePortWSDDServiceName;
    }

    public void setPackageServiceInterfacePortWSDDServiceName(String name) {
        this.PackageServiceInterfacePortWSDDServiceName = name;
    }

    @Override
    public PackageServiceInterface getPackageServiceInterfacePort() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL(this.PackageServiceInterfacePort_address);
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e);
        }
        return this.getPackageServiceInterfacePort(endpoint);
    }

    @Override
    public PackageServiceInterface getPackageServiceInterfacePort(URL portAddress) throws ServiceException {
        try {
            PackageServiceSoapBindingStub _stub = new PackageServiceSoapBindingStub(portAddress, this);
            _stub.setPortName(this.getPackageServiceInterfacePortWSDDServiceName());
            return _stub;
        }
        catch (AxisFault e) {
            return null;
        }
    }

    public void setPackageServiceInterfacePortEndpointAddress(String address) {
        this.PackageServiceInterfacePort_address = address;
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        try {
            if (PackageServiceInterface.class.isAssignableFrom(serviceEndpointInterface)) {
                PackageServiceSoapBindingStub _stub = new PackageServiceSoapBindingStub(new URL(this.PackageServiceInterfacePort_address), this);
                _stub.setPortName(this.getPackageServiceInterfacePortWSDDServiceName());
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        String string = String.valueOf(serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName());
        throw new ServiceException(string.length() != 0 ? "There is no stub implementation for the interface:  ".concat(string) : new String("There is no stub implementation for the interface:  "));
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (portName == null) {
            return this.getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("PackageServiceInterfacePort".equals(inputPortName)) {
            return this.getPackageServiceInterfacePort();
        }
        Remote _stub = this.getPort(serviceEndpointInterface);
        ((Stub)_stub).setPortName(portName);
        return _stub;
    }

    public QName getServiceName() {
        return new QName("https://www.google.com/apis/ads/publisher/v201502", "PackageService");
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("https://www.google.com/apis/ads/publisher/v201502", "PackageServiceInterfacePort"));
        }
        return this.ports.iterator();
    }

    public void setEndpointAddress(String portName, String address) throws ServiceException {
        if (!"PackageServiceInterfacePort".equals(portName)) {
            String string = String.valueOf(portName);
            throw new ServiceException(string.length() != 0 ? " Cannot set Endpoint Address for Unknown Port".concat(string) : new String(" Cannot set Endpoint Address for Unknown Port"));
        }
        this.setPackageServiceInterfacePortEndpointAddress(address);
    }

    public void setEndpointAddress(QName portName, String address) throws ServiceException {
        this.setEndpointAddress(portName.getLocalPart(), address);
    }
}

