/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfp.axis;

import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.client.HeaderHandler;
import com.google.api.ads.common.lib.conf.AdsLibConfiguration;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.AuthorizationHeaderHandler;
import com.google.api.ads.common.lib.soap.SoapClientHandlerInterface;
import com.google.api.ads.common.lib.useragent.UserAgentCombiner;
import com.google.api.ads.dfp.lib.client.DfpServiceDescriptor;
import com.google.api.ads.dfp.lib.client.DfpSession;
import com.google.api.ads.dfp.lib.conf.DfpApiConfiguration;
import com.google.api.ads.dfp.lib.soap.DfpHttpHeaderHandler;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.BeanUtils;

public class DfpAxisHeaderHandler
implements HeaderHandler<DfpSession, DfpServiceDescriptor> {
    private final SoapClientHandlerInterface<Object> soapClientHandler;
    private final DfpApiConfiguration dfpApiConfiguration;
    private final AuthorizationHeaderHandler authorizationHeaderHandler;
    private final DfpHttpHeaderHandler dfpHttpHeaderHandler;
    private final UserAgentCombiner userAgentCombiner;
    private final AdsLibConfiguration adsLibConfiguration;

    @Inject
    public DfpAxisHeaderHandler(SoapClientHandlerInterface soapClientHandler, DfpApiConfiguration dfpApiConfiguration, AdsLibConfiguration adsLibConfiguration, AuthorizationHeaderHandler authorizationHeaderHandler, DfpHttpHeaderHandler dfpHttpHeaderHandler, UserAgentCombiner userAgentCombiner) {
        this.soapClientHandler = soapClientHandler;
        this.dfpApiConfiguration = dfpApiConfiguration;
        this.adsLibConfiguration = adsLibConfiguration;
        this.authorizationHeaderHandler = authorizationHeaderHandler;
        this.dfpHttpHeaderHandler = dfpHttpHeaderHandler;
        this.userAgentCombiner = userAgentCombiner;
    }

    public void setHeaders(Object soapClient, DfpSession dfpSession, DfpServiceDescriptor dfpServiceDescriptor) throws AuthenticationException, ServiceException {
        try {
            this.dfpHttpHeaderHandler.setHttpHeaders(soapClient, dfpSession);
            Object soapHeader = this.createSoapHeader(dfpServiceDescriptor);
            BeanUtils.setProperty((Object)soapHeader, (String)"applicationName", (Object)this.userAgentCombiner.getUserAgent(dfpSession.getApplicationName()));
            if (dfpSession.getNetworkCode() != null) {
                BeanUtils.setProperty((Object)soapHeader, (String)"networkCode", (Object)dfpSession.getNetworkCode());
            }
            this.setAuthenticationHeaders(dfpServiceDescriptor, soapClient, soapHeader, dfpSession);
            String string = String.valueOf(this.dfpApiConfiguration.getNamespacePrefix());
            String string2 = String.valueOf(dfpServiceDescriptor.getVersion());
            String namespace = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/").append(string2).toString();
            this.soapClientHandler.setHeader(soapClient, namespace, "RequestHeader", soapHeader);
            this.soapClientHandler.setCompression(soapClient, this.adsLibConfiguration.isCompressionEnabled());
            this.soapClientHandler.setRequestTimeout(soapClient, this.adsLibConfiguration.getSoapRequestTimeout());
        }
        catch (InstantiationException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
        catch (SecurityException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
    }

    @VisibleForTesting
    void setAuthenticationHeaders(DfpServiceDescriptor dfpServiceDescriptor, Object soapClient, Object soapHeader, DfpSession dfpSession) throws AuthenticationException {
        this.authorizationHeaderHandler.setAuthorization(soapClient, (AdsSession)dfpSession);
    }

    @VisibleForTesting
    Object createSoapHeader(DfpServiceDescriptor adsServiceDescriptor) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return Class.forName(String.valueOf(adsServiceDescriptor.getInterfaceClass().getPackage().getName()).concat(".SoapRequestHeader")).newInstance();
    }
}

