/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfp.axis.utils.v201502;

import com.google.api.ads.dfp.axis.v201502.ExportFormat;
import com.google.api.ads.dfp.axis.v201502.ReportDownloadOptions;
import com.google.api.ads.dfp.axis.v201502.ReportJobStatus;
import com.google.api.ads.dfp.axis.v201502.ReportServiceInterface;
import com.google.api.ads.dfp.lib.utils.ReportCallback;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.util.Set;
import java.util.zip.GZIPInputStream;

public class ReportDownloader {
    public static final Charset REPORT_CHARSET = Charset.forName("UTF-8");
    public static final int SLEEP_TIMER = 30000;
    private final ReportServiceInterface reportService;
    private final long reportJobId;
    private static final Set<ExportFormat> SUPPORTED_CHARSOURCE_EXPORT_FORMATS = ImmutableSet.of((Object)ExportFormat.CSV_DUMP, (Object)ExportFormat.TSV, (Object)ExportFormat.XML);

    public ReportDownloader(ReportServiceInterface reportService, long reportJobId) {
        this.reportJobId = reportJobId;
        this.reportService = reportService;
    }

    public Thread whenReportReady(final ReportCallback callback) {
        Preconditions.checkNotNull((Object)callback, (Object)"Report callback cannot be null.");
        long l = this.reportJobId;
        Thread waitThread = new Thread(new StringBuilder(48).append("ReportUtils.whenReportReady ").append(l).toString()){

            @Override
            public void run() {
                try {
                    if (ReportDownloader.this.waitForReportReady()) {
                        callback.onSuccess();
                    } else {
                        callback.onFailure();
                    }
                }
                catch (RemoteException e) {
                    callback.onException((Exception)e);
                }
                catch (InterruptedException e) {
                    callback.onInterruption();
                }
                catch (RuntimeException e) {
                    callback.onException((Exception)e);
                }
            }
        };
        waitThread.start();
        return waitThread;
    }

    public boolean waitForReportReady() throws RemoteException, InterruptedException {
        ReportJobStatus status = this.reportService.getReportJob(this.reportJobId).getReportJobStatus();
        while (status == ReportJobStatus.IN_PROGRESS) {
            Thread.sleep(30000L);
            status = this.reportService.getReportJob(this.reportJobId).getReportJobStatus();
        }
        return status == ReportJobStatus.COMPLETED;
    }

    @Deprecated
    public void downloadReport(ExportFormat exportFormat, String fileName) throws IOException {
        this.downloadReport(exportFormat, new FileOutputStream(fileName));
    }

    @Deprecated
    public void downloadReport(ExportFormat exportFormat, OutputStream outputStream) throws IOException {
        ReportDownloadOptions options = new ReportDownloadOptions();
        options.setExportFormat(exportFormat);
        options.setUseGzipCompression(true);
        Resources.asByteSource((URL)this.getDownloadUrl(options)).copyTo(outputStream);
    }

    @Deprecated
    public String getReport(ExportFormat exportFormat) throws IOException {
        ReportDownloadOptions options = new ReportDownloadOptions();
        options.setExportFormat(exportFormat);
        options.setUseGzipCompression(true);
        return this.getReportAsCharSource(options).read();
    }

    public URL getDownloadUrl(ReportDownloadOptions options) throws RemoteException, MalformedURLException {
        ReportJobStatus status = this.reportService.getReportJob(this.reportJobId).getReportJobStatus();
        boolean bl = status == ReportJobStatus.COMPLETED;
        long l = this.reportJobId;
        String string = String.valueOf(status);
        Preconditions.checkState((boolean)bl, (Object)new StringBuilder(83 + String.valueOf(string).length()).append("Report ").append(l).append(" must be completed before downloading. It is currently: ").append(string).toString());
        return new URL(this.reportService.getReportDownloadUrlWithOptions(this.reportJobId, options));
    }

    public CharSource getReportAsCharSource(ReportDownloadOptions options) throws IOException {
        String string = String.valueOf(options.getExportFormat());
        Preconditions.checkArgument((boolean)SUPPORTED_CHARSOURCE_EXPORT_FORMATS.contains(options.getExportFormat()), (Object)new StringBuilder(44 + String.valueOf(string).length()).append("ExportFormat ").append(string).append(" cannot be used with CharSource").toString());
        ByteSource byteSource = Resources.asByteSource((URL)this.getDownloadUrl(options));
        return (options.getUseGzipCompression() != false ? new GZippedByteSource(byteSource) : byteSource).asCharSource(REPORT_CHARSET);
    }

    private static class GZippedByteSource
    extends ByteSource {
        private ByteSource containedByteSource;

        public GZippedByteSource(ByteSource zippedByteSource) {
            this.containedByteSource = zippedByteSource;
        }

        public InputStream openStream() throws IOException {
            return new GZIPInputStream(this.containedByteSource.openStream());
        }
    }
}

