/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfp.axis.utils.v201111;

import com.google.api.ads.dfp.axis.utils.v201111.DateTimes;
import com.google.api.ads.dfp.axis.v201111.Date;
import com.google.api.ads.dfp.axis.v201111.DateTime;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public final class Dates {
    public static final String DATE_FORMAT = "yyyy-MM-dd";

    private Dates() {
    }

    public static Date fromString(String dateString) throws ParseException {
        return Dates.fromDate(new SimpleDateFormat(DATE_FORMAT).parse(dateString));
    }

    public static Date fromDate(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Date dfpDate = new Date();
        dfpDate.setYear(calendar.get(1));
        dfpDate.setMonth(calendar.get(2) + 1);
        dfpDate.setDay(calendar.get(5));
        return dfpDate;
    }

    public static Date today(String timeZoneId) {
        return DateTimes.today(timeZoneId).getDate();
    }

    public static java.util.Date toDate(Date date, String timeZoneId) {
        return DateTimes.toDate(new DateTime(date, 0, 0, 0, timeZoneId));
    }

    public static String toString(Date date, String timeZoneId) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone(timeZoneId));
        return dateFormat.format(Dates.toDate(date, timeZoneId));
    }
}

