/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.admanager.jaxws;

import com.google.api.ads.admanager.lib.client.AdManagerServiceDescriptor;
import com.google.api.ads.admanager.lib.client.AdManagerSession;
import com.google.api.ads.admanager.lib.conf.AdManagerApiConfiguration;
import com.google.api.ads.admanager.lib.soap.AdManagerHttpHeaderHandler;
import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.client.HeaderHandler;
import com.google.api.ads.common.lib.conf.AdsLibConfiguration;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.AuthorizationHeaderHandler;
import com.google.api.ads.common.lib.soap.jaxws.JaxWsHandler;
import com.google.api.ads.common.lib.useragent.UserAgentCombiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.ws.BindingProvider;

public class AdManagerJaxWsHeaderHandler
implements HeaderHandler<AdManagerSession, AdManagerServiceDescriptor> {
    private static final String REQUEST_HEADER_LOCAL_PART = "RequestHeader";
    private final JaxWsHandler soapClientHandler;
    private final AdManagerApiConfiguration adManagerApiConfiguration;
    private final AdsLibConfiguration adsLibConfiguration;
    private final AuthorizationHeaderHandler authorizationHeaderHandler;
    private final AdManagerHttpHeaderHandler adManagerHttpHeaderHandler;
    private final UserAgentCombiner userAgentCombiner;

    @Inject
    public AdManagerJaxWsHeaderHandler(JaxWsHandler soapClientHandler, AdManagerApiConfiguration adManagerApiConfiguration, AdsLibConfiguration adsLibConfiguration, AuthorizationHeaderHandler authorizationHeaderHandler, AdManagerHttpHeaderHandler adManagerHttpHeaderHandler, UserAgentCombiner userAgentCombiner) {
        this.soapClientHandler = soapClientHandler;
        this.adManagerApiConfiguration = adManagerApiConfiguration;
        this.adsLibConfiguration = adsLibConfiguration;
        this.authorizationHeaderHandler = authorizationHeaderHandler;
        this.adManagerHttpHeaderHandler = adManagerHttpHeaderHandler;
        this.userAgentCombiner = userAgentCombiner;
    }

    public void setHeaders(Object soapClient, AdManagerSession adManagerSession, AdManagerServiceDescriptor adManagerServiceDescriptor) throws AuthenticationException, ServiceException {
        Preconditions.checkArgument((boolean)(soapClient instanceof BindingProvider), (String)"soapClient must be BindingProvider but was: %s", (Object)soapClient);
        BindingProvider bindingProvider = (BindingProvider)soapClient;
        this.adManagerHttpHeaderHandler.setHttpHeaders(soapClient, adManagerSession);
        Map<String, Object> headerData = this.readHeaderElements(adManagerSession);
        this.setAuthenticationHeaders(soapClient, adManagerSession);
        this.soapClientHandler.setHeader(bindingProvider, null, null, (Object)this.constructSoapHeader(headerData, adManagerServiceDescriptor));
        this.soapClientHandler.setCompression(bindingProvider, this.adsLibConfiguration.isCompressionEnabled());
        this.soapClientHandler.setRequestTimeout(bindingProvider, this.adsLibConfiguration.getSoapRequestTimeout());
    }

    private void setAuthenticationHeaders(Object soapClient, AdManagerSession adManagerSession) throws AuthenticationException {
        this.authorizationHeaderHandler.setAuthorization(soapClient, (AdsSession)adManagerSession);
    }

    private Map<String, Object> readHeaderElements(AdManagerSession adManagerSession) {
        LinkedHashMap mapToFill = Maps.newLinkedHashMap();
        mapToFill.put("networkCode", adManagerSession.getNetworkCode());
        mapToFill.put("applicationName", this.userAgentCombiner.getUserAgent(adManagerSession.getApplicationName()));
        return mapToFill;
    }

    private SOAPElement constructSoapHeader(Map<String, Object> headerData, AdManagerServiceDescriptor adManagerServiceDescriptor) {
        String requestHeaderNamespace = this.adManagerApiConfiguration.getNamespacePrefix() + "/" + adManagerServiceDescriptor.getVersion();
        try {
            SOAPFactory soapFactory = SOAPFactory.newInstance();
            SOAPElement requestHeader = soapFactory.createElement(REQUEST_HEADER_LOCAL_PART, "ns1", requestHeaderNamespace);
            for (String headerElementName : headerData.keySet()) {
                if (headerData.get(headerElementName) == null) continue;
                SOAPElement newElement = requestHeader.addChildElement(headerElementName, "ns1", requestHeaderNamespace);
                newElement.addTextNode(headerData.get(headerElementName).toString());
            }
            return requestHeader;
        }
        catch (SOAPException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
    }
}

