/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfp.jaxws;

import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.client.HeaderHandler;
import com.google.api.ads.common.lib.conf.AdsLibConfiguration;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.AuthorizationHeaderHandler;
import com.google.api.ads.common.lib.soap.jaxws.JaxWsHandler;
import com.google.api.ads.common.lib.useragent.UserAgentCombiner;
import com.google.api.ads.dfp.lib.client.DfpServiceDescriptor;
import com.google.api.ads.dfp.lib.client.DfpSession;
import com.google.api.ads.dfp.lib.conf.DfpApiConfiguration;
import com.google.api.ads.dfp.lib.soap.DfpHttpHeaderHandler;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.ws.BindingProvider;

public class DfpJaxWsHeaderHandler
implements HeaderHandler<DfpSession, DfpServiceDescriptor> {
    private static final String REQUEST_HEADER_LOCAL_PART = "RequestHeader";
    private final JaxWsHandler soapClientHandler;
    private final DfpApiConfiguration dfpApiConfiguration;
    private final AdsLibConfiguration adsLibConfiguration;
    private final AuthorizationHeaderHandler authorizationHeaderHandler;
    private final DfpHttpHeaderHandler dfpHttpHeaderHandler;
    private final UserAgentCombiner userAgentCombiner;

    @Inject
    public DfpJaxWsHeaderHandler(JaxWsHandler soapClientHandler, DfpApiConfiguration dfpApiConfiguration, AdsLibConfiguration adsLibConfiguration, AuthorizationHeaderHandler authorizationHeaderHandler, DfpHttpHeaderHandler dfpHttpHeaderHandler, UserAgentCombiner userAgentCombiner) {
        this.soapClientHandler = soapClientHandler;
        this.dfpApiConfiguration = dfpApiConfiguration;
        this.adsLibConfiguration = adsLibConfiguration;
        this.authorizationHeaderHandler = authorizationHeaderHandler;
        this.dfpHttpHeaderHandler = dfpHttpHeaderHandler;
        this.userAgentCombiner = userAgentCombiner;
    }

    public void setHeaders(Object soapClient, DfpSession dfpSession, DfpServiceDescriptor dfpServiceDescriptor) throws AuthenticationException, ServiceException {
        Preconditions.checkArgument((boolean)(soapClient instanceof BindingProvider), (String)"soapClient must be BindingProvider but was: %s", (Object)soapClient);
        BindingProvider bindingProvider = (BindingProvider)soapClient;
        this.dfpHttpHeaderHandler.setHttpHeaders(soapClient, dfpSession);
        Map<String, Object> headerData = this.readHeaderElements(dfpSession);
        this.setAuthenticationHeaders(soapClient, dfpSession);
        this.soapClientHandler.setHeader(bindingProvider, null, null, (Object)this.constructSoapHeader(headerData, dfpServiceDescriptor));
        this.soapClientHandler.setCompression(bindingProvider, this.adsLibConfiguration.isCompressionEnabled());
        this.soapClientHandler.setRequestTimeout(bindingProvider, this.adsLibConfiguration.getSoapRequestTimeout());
    }

    private void setAuthenticationHeaders(Object soapClient, DfpSession dfpSession) throws AuthenticationException {
        this.authorizationHeaderHandler.setAuthorization(soapClient, (AdsSession)dfpSession);
    }

    private Map<String, Object> readHeaderElements(DfpSession dfpSession) {
        LinkedHashMap mapToFill = Maps.newLinkedHashMap();
        mapToFill.put("networkCode", dfpSession.getNetworkCode());
        mapToFill.put("applicationName", this.userAgentCombiner.getUserAgent(dfpSession.getApplicationName()));
        return mapToFill;
    }

    private SOAPElement constructSoapHeader(Map<String, Object> headerData, DfpServiceDescriptor dfpServiceDescriptor) {
        String requestHeaderNamespace = this.dfpApiConfiguration.getNamespacePrefix() + "/" + dfpServiceDescriptor.getVersion();
        try {
            SOAPFactory soapFactory = SOAPFactory.newInstance();
            SOAPElement requestHeader = soapFactory.createElement(REQUEST_HEADER_LOCAL_PART, "ns1", requestHeaderNamespace);
            for (String headerElementName : headerData.keySet()) {
                if (headerData.get(headerElementName) == null) continue;
                SOAPElement newElement = requestHeader.addChildElement(headerElementName, "ns1", requestHeaderNamespace);
                newElement.addTextNode(headerData.get(headerElementName).toString());
            }
            return requestHeader;
        }
        catch (SOAPException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
    }
}

