/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utils.v201409;

import com.google.api.ads.adwords.axis.v201409.cm.DateRange;
import com.google.api.ads.adwords.axis.v201409.cm.OrderBy;
import com.google.api.ads.adwords.axis.v201409.cm.Paging;
import com.google.api.ads.adwords.axis.v201409.cm.Predicate;
import com.google.api.ads.adwords.axis.v201409.cm.PredicateOperator;
import com.google.api.ads.adwords.axis.v201409.cm.Selector;
import com.google.api.ads.adwords.axis.v201409.cm.SortOrder;
import com.google.api.ads.adwords.lib.selectorfields.EntityField;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.joda.time.DateTime;

public class SelectorBuilder {
    protected static final String DEFAULT_DATE_FORMAT = "yyyyMMdd";
    private static final String ID_PROPERTY = "Id";
    private Set<String> fields = Sets.newLinkedHashSet();
    private Set<OrderBy> ordering = Sets.newLinkedHashSet();
    private Set<Predicate> predicates = Sets.newLinkedHashSet();
    private DateRange dateRange;
    private Paging paging;

    public Selector build() {
        Selector selectorCopy = new Selector();
        Set<OrderBy> orderingCopy = this.copyOrderingSet();
        Set<Predicate> predicatesCopy = this.copyPredicatesSet();
        selectorCopy.setFields(this.fields.toArray(new String[this.fields.size()]));
        selectorCopy.setOrdering(orderingCopy.toArray(new OrderBy[this.ordering.size()]));
        selectorCopy.setPredicates(predicatesCopy.toArray(new Predicate[this.predicates.size()]));
        if (this.dateRange != null) {
            selectorCopy.setDateRange(new DateRange(this.dateRange.getMin(), this.dateRange.getMax()));
        }
        if (this.paging != null) {
            selectorCopy.setPaging(new Paging(this.paging.getStartIndex(), this.paging.getNumberResults()));
        }
        return selectorCopy;
    }

    private Set<Predicate> copyPredicatesSet() {
        LinkedHashSet predicatesCopy = Sets.newLinkedHashSet();
        for (Predicate predicate : this.predicates) {
            Predicate copyPredicate = new Predicate();
            copyPredicate.setField(predicate.getField());
            copyPredicate.setOperator(predicate.getOperator());
            copyPredicate.setValues(Arrays.copyOf(predicate.getValues(), predicate.getValues().length));
            predicatesCopy.add(copyPredicate);
        }
        return predicatesCopy;
    }

    private Set<OrderBy> copyOrderingSet() {
        LinkedHashSet orderingCopy = Sets.newLinkedHashSet();
        for (OrderBy order : this.ordering) {
            OrderBy copyOrder = new OrderBy();
            copyOrder.setField(order.getField());
            copyOrder.setSortOrder(order.getSortOrder());
            orderingCopy.add(copyOrder);
        }
        return orderingCopy;
    }

    public SelectorBuilder fields(String ... fields) {
        this.fields = Sets.newLinkedHashSet();
        Collections.addAll(this.fields, fields);
        return this;
    }

    public SelectorBuilder fields(EntityField ... fields) {
        return this.fields(this.enumFieldsToNames(fields));
    }

    private String[] enumFieldsToNames(EntityField ... fields) {
        String[] fieldsNames = new String[fields.length];
        int i = 0;
        while (i < fields.length) {
            fieldsNames[i] = fields[i].name();
            ++i;
        }
        return fieldsNames;
    }

    public SelectorBuilder increaseOffsetBy(int additionalOffset) {
        Integer startIndex;
        if (this.paging == null) {
            this.paging = new Paging();
        }
        if ((startIndex = this.paging.getStartIndex()) == null) {
            startIndex = 0;
        }
        this.paging.setStartIndex(startIndex + additionalOffset);
        return this;
    }

    public SelectorBuilder limit(int limit) {
        if (this.paging == null) {
            this.paging = new Paging();
        }
        this.paging.setNumberResults(limit);
        return this;
    }

    public SelectorBuilder offset(int offset) {
        if (this.paging == null) {
            this.paging = new Paging();
        }
        this.paging.setStartIndex(offset);
        return this;
    }

    public SelectorBuilder removeLimitAndOffset() {
        this.paging = null;
        return this;
    }

    public SelectorBuilder orderAscBy(String field) {
        OrderBy orderBy = new OrderBy();
        orderBy.setField(field);
        orderBy.setSortOrder(SortOrder.ASCENDING);
        this.ordering.add(orderBy);
        return this;
    }

    public SelectorBuilder orderAscBy(EntityField field) {
        return this.orderAscBy(field.name());
    }

    public SelectorBuilder orderDescBy(String field) {
        OrderBy orderBy = new OrderBy();
        orderBy.setField(field);
        orderBy.setSortOrder(SortOrder.DESCENDING);
        this.ordering.add(orderBy);
        return this;
    }

    public SelectorBuilder orderDescBy(EntityField field) {
        return this.orderDescBy(field.name());
    }

    public SelectorBuilder removeOrderBy(String field) {
        Iterator<OrderBy> iterator = this.ordering.iterator();
        while (iterator.hasNext()) {
            OrderBy order = iterator.next();
            if (!order.getField().equals(field)) continue;
            iterator.remove();
        }
        return this;
    }

    public SelectorBuilder removeOrderBy(EntityField field) {
        return this.removeOrderBy(field.name());
    }

    public SelectorBuilder forDateRange(DateTime start, DateTime end) {
        if (this.dateRange == null) {
            this.dateRange = new DateRange();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        if (start != null) {
            this.dateRange.setMin(dateFormat.format(start.toDate()));
        }
        if (end != null) {
            this.dateRange.setMax(dateFormat.format(end.toDate()));
        }
        return this;
    }

    public SelectorBuilder equals(String field, String propertyValue) {
        return this.singleValuePredicate(field, propertyValue, PredicateOperator.EQUALS);
    }

    public SelectorBuilder equals(EntityField field, String propertyValue) {
        return this.equals(field.name(), propertyValue);
    }

    public SelectorBuilder notEquals(String field, String propertyValue) {
        return this.singleValuePredicate(field, propertyValue, PredicateOperator.NOT_EQUALS);
    }

    public SelectorBuilder notEquals(EntityField field, String propertyValue) {
        return this.notEquals(field.name(), propertyValue);
    }

    public SelectorBuilder contains(String field, String propertyValue) {
        return this.singleValuePredicate(field, propertyValue, PredicateOperator.CONTAINS);
    }

    public SelectorBuilder contains(EntityField field, String propertyValue) {
        return this.contains(field.name(), propertyValue);
    }

    public SelectorBuilder containsIgnoreCase(String field, String propertyValue) {
        return this.singleValuePredicate(field, propertyValue, PredicateOperator.CONTAINS_IGNORE_CASE);
    }

    public SelectorBuilder containsIgnoreCase(EntityField field, String propertyValue) {
        return this.containsIgnoreCase(field.name(), propertyValue);
    }

    public SelectorBuilder doesNotContain(String field, String propertyValue) {
        return this.singleValuePredicate(field, propertyValue, PredicateOperator.DOES_NOT_CONTAIN);
    }

    public SelectorBuilder doesNotContain(EntityField field, String propertyValue) {
        return this.doesNotContain(field.name(), propertyValue);
    }

    public SelectorBuilder doesNotContainIgnoreCase(String field, String propertyValue) {
        return this.singleValuePredicate(field, propertyValue, PredicateOperator.DOES_NOT_CONTAIN_IGNORE_CASE);
    }

    public SelectorBuilder doesNotContainIgnoreCase(EntityField field, String propertyValue) {
        return this.doesNotContainIgnoreCase(field.name(), propertyValue);
    }

    public SelectorBuilder greaterThan(String field, long propertyValue) {
        return this.singleValuePredicate(field, Long.toString(propertyValue), PredicateOperator.GREATER_THAN);
    }

    public SelectorBuilder greaterThan(EntityField field, long propertyValue) {
        return this.greaterThan(field.name(), propertyValue);
    }

    public SelectorBuilder greaterThanEquals(String field, long propertyValue) {
        return this.singleValuePredicate(field, Long.toString(propertyValue), PredicateOperator.GREATER_THAN_EQUALS);
    }

    public SelectorBuilder greaterThanEquals(EntityField field, long propertyValue) {
        return this.greaterThanEquals(field.name(), propertyValue);
    }

    public SelectorBuilder lessThan(String field, long propertyValue) {
        return this.singleValuePredicate(field, Long.toString(propertyValue), PredicateOperator.LESS_THAN);
    }

    public SelectorBuilder lessThan(EntityField field, long propertyValue) {
        return this.lessThan(field.name(), propertyValue);
    }

    public SelectorBuilder lessThanEquals(String field, long propertyValue) {
        return this.singleValuePredicate(field, Long.toString(propertyValue), PredicateOperator.LESS_THAN_EQUALS);
    }

    public SelectorBuilder lessThanEquals(EntityField field, long propertyValue) {
        return this.lessThanEquals(field.name(), propertyValue);
    }

    private SelectorBuilder singleValuePredicate(String field, String propertyValue, PredicateOperator operator) {
        Predicate predicate = new Predicate();
        predicate.setField(field);
        predicate.setOperator(operator);
        String[] values = new String[]{propertyValue};
        predicate.setValues(values);
        this.predicates.add(predicate);
        return this;
    }

    public SelectorBuilder equalsId(Long id) {
        return this.singleValuePredicate(ID_PROPERTY, id.toString(), PredicateOperator.EQUALS);
    }

    public SelectorBuilder in(String field, String ... values) {
        return this.multipleValuePredicate(field, values, PredicateOperator.IN);
    }

    public SelectorBuilder in(EntityField field, String ... values) {
        return this.in(field.name(), values);
    }

    public SelectorBuilder notIn(String field, String ... values) {
        return this.multipleValuePredicate(field, values, PredicateOperator.NOT_IN);
    }

    public SelectorBuilder notIn(EntityField field, String ... values) {
        return this.notIn(field.name(), values);
    }

    public SelectorBuilder containsAny(String field, String ... values) {
        return this.multipleValuePredicate(field, values, PredicateOperator.CONTAINS_ANY);
    }

    public SelectorBuilder containsAny(EntityField field, String ... values) {
        return this.containsAny(field.name(), values);
    }

    public SelectorBuilder containsAll(String field, String ... values) {
        return this.multipleValuePredicate(field, values, PredicateOperator.CONTAINS_ALL);
    }

    public SelectorBuilder containsAll(EntityField field, String ... values) {
        return this.containsAll(field.name(), values);
    }

    public SelectorBuilder containsNone(String field, String ... values) {
        return this.multipleValuePredicate(field, values, PredicateOperator.CONTAINS_NONE);
    }

    public SelectorBuilder containsNone(EntityField field, String ... values) {
        return this.containsNone(field.name(), values);
    }

    private SelectorBuilder multipleValuePredicate(String field, String[] propertyValues, PredicateOperator operator) {
        if (propertyValues == null) {
            return this;
        }
        Predicate predicate = new Predicate();
        predicate.setOperator(operator);
        predicate.setField(field);
        String[] values = Arrays.copyOf(propertyValues, propertyValues.length);
        predicate.setValues(values);
        this.predicates.add(predicate);
        return this;
    }
}

