/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.commons.lang.SerializationException;

public class AxisReportDefinitionSerializer<T> {
    private static final String REMOVE_ATTRIBUTES_REGEX = "( )?(xmlns|xsi):(\\w)+=\".*?\"|ns\\d:|<\\?xml.*?>";
    private static final String REMOVE_SELF_CLOSING_TAG = "<\\w+( )?/>";
    private final Class<T> clazz;

    public AxisReportDefinitionSerializer(Class<T> clazz) {
        this.clazz = clazz;
    }

    public String serialize(T reportDefinition) {
        try {
            QName xmlType = this.getXmlType();
            Serializer serializer = this.getSerializer(xmlType);
            StringWriter writer = new StringWriter();
            SerializationContext context = new SerializationContext((Writer)writer);
            serializer.serialize(xmlType, null, reportDefinition, context);
            return this.sanitize(writer.toString());
        }
        catch (IllegalArgumentException e) {
            throw new SerializationException("Could not serialize report.", (Throwable)e);
        }
        catch (SecurityException e) {
            throw new SerializationException("Could not serialize report.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("Could not serialize report.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new SerializationException("Could not serialize report.", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new SerializationException("Could not serialize report.", (Throwable)e);
        }
        catch (IOException e) {
            throw new SerializationException("Could not serialize report.", (Throwable)e);
        }
    }

    @VisibleForTesting
    Serializer getSerializer(QName xmlType) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method getSerializer = this.clazz.getMethod("getSerializer", String.class, Class.class, QName.class);
        return (Serializer)getSerializer.invoke(null, "reportDefinition", this.clazz, xmlType);
    }

    @VisibleForTesting
    QName getXmlType() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Method getTypeDesc = this.clazz.getMethod("getTypeDesc", new Class[0]);
        TypeDesc typeDesc = (TypeDesc)getTypeDesc.invoke(null, new Object[0]);
        return typeDesc.getXmlType();
    }

    @VisibleForTesting
    String sanitize(String string) {
        string = string.replaceAll(REMOVE_ATTRIBUTES_REGEX, "");
        string = string.replaceAll(REMOVE_SELF_CLOSING_TAG, "");
        string = string.replaceAll("ReportDefinition", "reportDefinition");
        return string;
    }
}

