/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.v201109.cm;

import com.google.api.ads.adwords.v201109.cm.MediaService;
import com.google.api.ads.adwords.v201109.cm.MediaServiceInterface;
import com.google.api.ads.adwords.v201109.cm.MediaServiceSoapBindingStub;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;

public class MediaServiceLocator
extends Service
implements MediaService {
    private String MediaServiceInterfacePort_address = "https://adwords.google.com/api/adwords/cm/v201109/MediaService";
    private String MediaServiceInterfacePortWSDDServiceName = "MediaServiceInterfacePort";
    private HashSet ports = null;

    public MediaServiceLocator() {
    }

    public MediaServiceLocator(EngineConfiguration config) {
        super(config);
    }

    public MediaServiceLocator(String wsdlLoc, QName sName) throws ServiceException {
        super(wsdlLoc, sName);
    }

    public String getMediaServiceInterfacePortAddress() {
        return this.MediaServiceInterfacePort_address;
    }

    public String getMediaServiceInterfacePortWSDDServiceName() {
        return this.MediaServiceInterfacePortWSDDServiceName;
    }

    public void setMediaServiceInterfacePortWSDDServiceName(String name) {
        this.MediaServiceInterfacePortWSDDServiceName = name;
    }

    public MediaServiceInterface getMediaServiceInterfacePort() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL(this.MediaServiceInterfacePort_address);
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e);
        }
        return this.getMediaServiceInterfacePort(endpoint);
    }

    public MediaServiceInterface getMediaServiceInterfacePort(URL portAddress) throws ServiceException {
        try {
            MediaServiceSoapBindingStub _stub = new MediaServiceSoapBindingStub(portAddress, this);
            _stub.setPortName(this.getMediaServiceInterfacePortWSDDServiceName());
            return _stub;
        }
        catch (AxisFault axisFault) {
            return null;
        }
    }

    public void setMediaServiceInterfacePortEndpointAddress(String address) {
        this.MediaServiceInterfacePort_address = address;
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        try {
            if (MediaServiceInterface.class.isAssignableFrom(serviceEndpointInterface)) {
                MediaServiceSoapBindingStub _stub = new MediaServiceSoapBindingStub(new URL(this.MediaServiceInterfacePort_address), this);
                _stub.setPortName(this.getMediaServiceInterfacePortWSDDServiceName());
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        throw new ServiceException("There is no stub implementation for the interface:  " + (serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName()));
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (portName == null) {
            return this.getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("MediaServiceInterfacePort".equals(inputPortName)) {
            return this.getMediaServiceInterfacePort();
        }
        Remote _stub = this.getPort(serviceEndpointInterface);
        ((Stub)_stub).setPortName(portName);
        return _stub;
    }

    public QName getServiceName() {
        return new QName("https://adwords.google.com/api/adwords/cm/v201109", "MediaService");
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("https://adwords.google.com/api/adwords/cm/v201109", "MediaServiceInterfacePort"));
        }
        return this.ports.iterator();
    }

    public void setEndpointAddress(String portName, String address) throws ServiceException {
        if (!"MediaServiceInterfacePort".equals(portName)) {
            throw new ServiceException(" Cannot set Endpoint Address for Unknown Port" + portName);
        }
        this.setMediaServiceInterfacePortEndpointAddress(address);
    }

    public void setEndpointAddress(QName portName, String address) throws ServiceException {
        this.setEndpointAddress(portName.getLocalPart(), address);
    }
}

