/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.factory;

import com.google.api.ads.common.lib.client.AdsServiceClient;
import com.google.api.ads.common.lib.client.AdsServiceDescriptor;
import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.factory.helper.AdsServiceClientFactoryHelper;
import com.google.api.ads.common.lib.soap.SoapServiceClient;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.lang.reflect.Proxy;
import java.util.HashSet;

public class AdsServiceClientFactory<C extends AdsServiceClient<S, D>, S extends AdsSession, D extends AdsServiceDescriptor> {
    private final AdsServiceClientFactoryHelper<C, S, D> adsServiceFactoryHelper;

    @Inject
    public AdsServiceClientFactory(AdsServiceClientFactoryHelper adsServiceClientFactoryHelper) {
        this.adsServiceFactoryHelper = adsServiceClientFactoryHelper;
    }

    public synchronized <T> T getServiceClient(S adsSession, Class<T> interfaceClass) throws ServiceException {
        this.adsServiceFactoryHelper.checkServiceClientPreconditions(adsSession, interfaceClass);
        String version = this.adsServiceFactoryHelper.determineVersion(interfaceClass);
        D adsServiceDescriptor = this.adsServiceFactoryHelper.createServiceDescriptor(interfaceClass, version);
        C adsServiceClient = this.adsServiceFactoryHelper.createAdsServiceClient(adsServiceDescriptor, adsSession);
        return this.createProxy(interfaceClass, adsServiceClient);
    }

    <T> T createProxy(Class<T> interfaceClass, C adsServiceClient) {
        HashSet interfaces = Sets.newHashSet((Object[])adsServiceClient.getClass().getInterfaces());
        interfaces.add(interfaceClass);
        Object proxy = Proxy.newProxyInstance(((SoapServiceClient)adsServiceClient).getSoapClient().getClass().getClassLoader(), interfaces.toArray(new Class[0]), adsServiceClient);
        return interfaceClass.cast(proxy);
    }
}

