/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.io.ByteSource;
import com.google.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class BatchJobHelperUtility {
    private static final String TAG_MUTATE_RESPONSE = "mutateResponse";
    private static final String TAG_RVAL = "rval";
    private final Supplier<Transformer> transformerSupplier;
    private final XMLInputFactory xmlInputFactory;
    private final XMLOutputFactory xmlOutputFactory;
    private final XMLEventFactory xmlEventFactory;

    @Inject
    BatchJobHelperUtility(Supplier<Transformer> transformerSupplier, XMLInputFactory xmlInputFactory, XMLOutputFactory xmlOutputFactory, XMLEventFactory xmlEventFactory) {
        this.transformerSupplier = transformerSupplier;
        this.xmlInputFactory = xmlInputFactory;
        this.xmlOutputFactory = xmlOutputFactory;
        this.xmlEventFactory = xmlEventFactory;
    }

    public ByteSource buildWrappedByteSource(URL url, int startIndex, int numberResults) throws IOException, XMLStreamException, TransformerException {
        Preconditions.checkArgument((startIndex >= 0 ? 1 : 0) != 0, (Object)"startIndex must not be negative");
        Preconditions.checkArgument((numberResults > 0 ? 1 : 0) != 0, (Object)"numberResults must be positive");
        StringWriter stringWriter = new StringWriter();
        XMLEventReader xmlEventReader = this.xmlInputFactory.createXMLEventReader(url.openStream());
        XMLEventWriter xmlEventWriter = this.xmlOutputFactory.createXMLEventWriter(stringWriter);
        int index = 0;
        boolean included = false;
        while (xmlEventReader.hasNext()) {
            String name;
            XMLEvent event = xmlEventReader.nextEvent();
            if (event.isStartElement()) {
                name = ((StartElement)event).getName().getLocalPart();
                if (name.equals(TAG_MUTATE_RESPONSE)) {
                    xmlEventWriter.add(event);
                    continue;
                }
                if (name.equals(TAG_RVAL) && ++index > startIndex) {
                    included = true;
                }
            } else if (event.isEndElement()) {
                name = ((EndElement)event).getName().getLocalPart();
                if (name.equals(TAG_MUTATE_RESPONSE)) {
                    xmlEventWriter.add(event);
                    break;
                }
                if (included && name.equals(TAG_RVAL) && index == startIndex + numberResults) {
                    xmlEventWriter.add(event);
                    xmlEventWriter.add(this.xmlEventFactory.createEndElement("", "", TAG_MUTATE_RESPONSE));
                    break;
                }
            }
            if (!included) continue;
            xmlEventWriter.add(event);
        }
        xmlEventReader.close();
        xmlEventWriter.close();
        InputStream truncatedInputStream = ByteSource.wrap((byte[])stringWriter.toString().getBytes(StandardCharsets.UTF_8)).openStream();
        Transformer transformer = (Transformer)this.transformerSupplier.get();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(outputStream);
        StreamSource xmlSource = new StreamSource(truncatedInputStream);
        transformer.transform(xmlSource, streamResult);
        return ByteSource.wrap((byte[])outputStream.toByteArray());
    }
}

