/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.admanager.lib.utils;

import com.google.api.ads.admanager.lib.utils.QueryBuilderInterface;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;

public class QueryBuilder<V>
implements QueryBuilderInterface<V> {
    protected static final String SELECT = "SELECT";
    protected static final String FROM = "FROM";
    protected static final String WHERE = "WHERE";
    protected static final String LIMIT = "LIMIT";
    protected static final String OFFSET = "OFFSET";
    protected static final String ORDER_BY = "ORDER BY";
    protected String select;
    protected String from;
    protected String where;
    protected Integer limit = null;
    protected Integer offset = null;
    protected String orderBy;
    protected Map<String, V> valueMap = Maps.newHashMap();

    static String removeKeyword(String clause, String keyword) {
        if (clause.regionMatches(true, 0, keyword = keyword + " ", 0, keyword.length())) {
            return clause.substring(keyword.length());
        }
        return clause;
    }

    @Override
    public QueryBuilder<V> select(String columns) {
        Preconditions.checkNotNull((Object)columns, (Object)"SELECT clause cannot be null");
        this.select = columns = QueryBuilder.removeKeyword(columns, SELECT);
        return this;
    }

    @Override
    public QueryBuilder<V> from(String table) {
        Preconditions.checkNotNull((Object)table, (Object)"FROM clause cannot be null");
        this.from = table = QueryBuilder.removeKeyword(table, FROM);
        return this;
    }

    @Override
    public QueryBuilder<V> where(String conditions) {
        Preconditions.checkNotNull((Object)conditions, (Object)"WHERE clause cannot be null");
        this.where = conditions = QueryBuilder.removeKeyword(conditions, WHERE);
        return this;
    }

    @Override
    public QueryBuilder<V> limit(Integer count) {
        this.limit = count;
        return this;
    }

    @Override
    public QueryBuilder<V> offset(Integer count) {
        this.offset = count;
        return this;
    }

    @Override
    public QueryBuilder<V> increaseOffsetBy(Integer amount) {
        if (this.offset == null) {
            this.offset = 0;
        }
        QueryBuilder queryBuilder = this;
        queryBuilder.offset = queryBuilder.offset + amount;
        return this;
    }

    @Override
    public Integer getOffset() {
        return this.offset;
    }

    @Override
    public QueryBuilder<V> removeLimitAndOffset() {
        this.offset = null;
        this.limit = null;
        return this;
    }

    @Override
    public QueryBuilder<V> orderBy(String orderBy) {
        Preconditions.checkNotNull((Object)orderBy, (Object)"ORDER BY clause cannot be null");
        this.orderBy = orderBy = QueryBuilder.removeKeyword(orderBy, ORDER_BY);
        return this;
    }

    @Override
    public QueryBuilder<V> withBindVariableValue(String key, V value) {
        this.valueMap.put(key, value);
        return this;
    }

    public QueryBuilder<V> withBindVariableValues(Map<String, V> values) {
        this.valueMap.putAll(values);
        return this;
    }

    @Override
    public Map<String, V> getBindVariableMap() {
        return Collections.unmodifiableMap(this.valueMap);
    }

    protected void validateQuery() {
        Preconditions.checkState((this.limit != null || this.limit == null && this.offset == null ? 1 : 0) != 0, (Object)"OFFSET cannot be set if LIMIT is not set.");
    }

    @Override
    public String buildQuery() {
        this.validateQuery();
        StringBuilder stringBuilder = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)this.select)) {
            stringBuilder = stringBuilder.append(SELECT).append(" ").append(this.select).append(" ");
        }
        if (!Strings.isNullOrEmpty((String)this.from)) {
            stringBuilder = stringBuilder.append(FROM).append(" ").append(this.from).append(" ");
        }
        if (!Strings.isNullOrEmpty((String)this.where)) {
            stringBuilder = stringBuilder.append(WHERE).append(" ").append(this.where).append(" ");
        }
        if (!Strings.isNullOrEmpty((String)this.orderBy)) {
            stringBuilder = stringBuilder.append(ORDER_BY).append(" ").append(this.orderBy).append(" ");
        }
        if (this.limit != null) {
            stringBuilder = stringBuilder.append(LIMIT).append(" ").append(this.limit).append(" ");
        }
        if (this.offset != null) {
            stringBuilder = stringBuilder.append(OFFSET).append(" ").append(this.offset).append(" ");
        }
        return stringBuilder.toString().trim();
    }
}

