/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.factory;

import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.factory.AdWordsSessionModule;
import com.google.api.ads.adwords.lib.factory.DependencyBootstrapper;
import com.google.api.ads.adwords.lib.utils.SessionUtility;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;

class DependencyBootstrapperImpl
implements DependencyBootstrapper {
    private final Injector injector;

    @Inject
    DependencyBootstrapperImpl(Injector injector) {
        this.injector = injector;
    }

    @Override
    public <T> T getInstanceOf(AdWordsSession session, Class<T> dependencyClass) {
        Preconditions.checkNotNull((Object)session, (Object)"Null session");
        Preconditions.checkNotNull(dependencyClass, (Object)"Null dependency class");
        if (dependencyClass.getAnnotation(SessionUtility.class) != null) {
            String message = String.format("%s is annotated with %s. Only types without that annotation can be obtained  from this bootstrapper. Use AdWordsServicesInterface.getUtility instead.", dependencyClass, SessionUtility.class);
            throw new IllegalArgumentException(message);
        }
        Injector childInjector = this.injector.createChildInjector(new Module[]{new AdWordsSessionModule(session)});
        return (T)childInjector.getInstance(dependencyClass);
    }
}

