/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.client.reporting;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@ThreadSafe
public class ReportingConfiguration {
    private final Boolean isSkipReportHeader;
    private final Boolean isSkipColumnHeader;
    private final Boolean isSkipReportSummary;
    private final Boolean isIncludeZeroImpressions;
    private final Boolean isUseRawEnumValues;
    private final Integer reportDownloadTimeout;

    private ReportingConfiguration(Builder builder) {
        this.isSkipReportHeader = builder.isSkipReportHeader;
        this.isSkipColumnHeader = builder.isSkipColumnHeader;
        this.isSkipReportSummary = builder.isSkipReportSummary;
        this.isIncludeZeroImpressions = builder.isIncludeZeroImpressions;
        this.isUseRawEnumValues = builder.isUseRawEnumValues;
        this.reportDownloadTimeout = builder.reportDownloadTimeout;
    }

    @Nullable
    public Boolean isSkipReportHeader() {
        return this.isSkipReportHeader;
    }

    @Nullable
    public Boolean isSkipColumnHeader() {
        return this.isSkipColumnHeader;
    }

    @Nullable
    public Boolean isSkipReportSummary() {
        return this.isSkipReportSummary;
    }

    @Nullable
    public Boolean isIncludeZeroImpressions() {
        return this.isIncludeZeroImpressions;
    }

    @Nullable
    public Boolean isUseRawEnumValues() {
        return this.isUseRawEnumValues;
    }

    @Nullable
    public Integer getReportDownloadTimeout() {
        return this.reportDownloadTimeout;
    }

    public void validate(@Nullable String version) {
        if (this.reportDownloadTimeout != null) {
            Preconditions.checkArgument((this.reportDownloadTimeout >= 0 ? 1 : 0) != 0, (String)"Report download timeout is < 0: %s", (Object)this.reportDownloadTimeout);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("isSkipReportHeader", (Object)this.isSkipReportHeader).append("isSkipColumnHeader", (Object)this.isSkipColumnHeader).append("isSkipReportSummary", (Object)this.isSkipReportSummary).append("isIncludeZeroImpressions", (Object)this.isIncludeZeroImpressions).append("isUseRawEnumValues", (Object)this.isUseRawEnumValues).append("reportDownloadTimeout", (Object)this.reportDownloadTimeout).toString();
    }

    public static class Builder {
        private Boolean isSkipReportHeader;
        private Boolean isSkipColumnHeader;
        private Boolean isSkipReportSummary;
        private Boolean isIncludeZeroImpressions;
        private Boolean isUseRawEnumValues;
        private Integer reportDownloadTimeout;

        public Builder skipReportHeader(Boolean isSkipReportHeader) {
            this.isSkipReportHeader = isSkipReportHeader;
            return this;
        }

        public Builder skipColumnHeader(Boolean isSkipColumnHeader) {
            this.isSkipColumnHeader = isSkipColumnHeader;
            return this;
        }

        public Builder skipReportSummary(Boolean isSkipReportSummary) {
            this.isSkipReportSummary = isSkipReportSummary;
            return this;
        }

        public Builder includeZeroImpressions(Boolean isIncludeZeroImpressions) {
            this.isIncludeZeroImpressions = isIncludeZeroImpressions;
            return this;
        }

        public Builder useRawEnumValues(Boolean isUseRawEnumValues) {
            this.isUseRawEnumValues = isUseRawEnumValues;
            return this;
        }

        public Builder reportDownloadTimeout(@Nullable Integer reportDownloadTimeout) {
            this.reportDownloadTimeout = reportDownloadTimeout;
            return this;
        }

        public ReportingConfiguration build() {
            return new ReportingConfiguration(this);
        }
    }
}

