/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils;

import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.utils.AdWordsInternals;
import com.google.api.ads.adwords.lib.utils.BatchJobException;
import com.google.api.ads.adwords.lib.utils.BatchJobMutateRequestInterface;
import com.google.api.ads.adwords.lib.utils.BatchJobMutateResponseInterface;
import com.google.api.ads.adwords.lib.utils.BatchJobMutateResultInterface;
import com.google.api.ads.adwords.lib.utils.BatchJobUploadBodyProvider;
import com.google.api.ads.adwords.lib.utils.BatchJobUploadResponse;
import com.google.api.ads.adwords.lib.utils.BatchJobUploadStatus;
import com.google.api.ads.common.lib.soap.RequestInfo;
import com.google.api.ads.common.lib.soap.ResponseInfo;
import com.google.api.ads.common.lib.soap.SoapCallReturn;
import com.google.api.ads.common.lib.useragent.UserAgentCombiner;
import com.google.api.ads.common.lib.utils.Streams;
import com.google.api.ads.common.lib.utils.logging.AdsServiceLoggers;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.util.Charsets;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;

public class BatchJobUploader<OperandT, ApiErrorT, ResultT extends BatchJobMutateResultInterface<OperandT, ApiErrorT>, ResponseT extends BatchJobMutateResponseInterface<OperandT, ApiErrorT, ResultT>> {
    private final AdWordsSession session;
    private final HttpTransport httpTransport;
    private final UserAgentCombiner userAgentCombiner;
    private final AdsServiceLoggers serviceLoggers;
    private static final Charset REQUEST_CHARSET = Charsets.UTF_8;

    public BatchJobUploader(AdWordsSession session) {
        this.session = session;
        this.httpTransport = AdWordsInternals.getInstance().getHttpTransport();
        this.userAgentCombiner = AdWordsInternals.getInstance().getUserAgentCombiner();
        this.serviceLoggers = AdWordsInternals.getInstance().getAdsServiceLoggers();
    }

    private HttpHeaders createHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType("application/xml");
        headers.setUserAgent(this.userAgentCombiner.getUserAgent(this.session.getUserAgent()));
        return headers;
    }

    public BatchJobUploadResponse uploadBatchJobOperations(BatchJobMutateRequestInterface request, String uploadUrl) throws BatchJobException {
        Preconditions.checkNotNull((Object)request, (Object)"Null request");
        String requestXml = null;
        String responseMessage = null;
        IOException exception = null;
        BatchJobUploadResponse batchJobUploadResponse = null;
        try {
            HttpRequestFactory requestFactory = this.httpTransport.createRequestFactory(new HttpRequestInitializer(){

                public void initialize(HttpRequest request) throws IOException {
                    request.setHeaders(BatchJobUploader.this.createHttpHeaders());
                    request.setLoggingEnabled(true);
                }
            });
            BatchJobUploadBodyProvider bodyProvider = request.createBatchJobUploadBodyProvider();
            ByteArrayContent content = bodyProvider.getHttpContent(request, true, true);
            HttpRequest httpRequest = requestFactory.buildPostRequest(new GenericUrl(uploadUrl), (HttpContent)content);
            requestXml = Streams.readAll(content.getInputStream(), REQUEST_CHARSET);
            content.getInputStream().reset();
            HttpResponse response = httpRequest.execute();
            batchJobUploadResponse = new BatchJobUploadResponse(response, httpRequest.getContent().getLength(), null);
            responseMessage = String.format("%s: %s", response.getStatusCode(), response.getStatusMessage());
            BatchJobUploadResponse batchJobUploadResponse2 = batchJobUploadResponse;
            this.logRequestResponse(requestXml, responseMessage, uploadUrl, "uploadBatchJobOperations", batchJobUploadResponse, exception);
            return batchJobUploadResponse2;
        }
        catch (IOException e) {
            try {
                responseMessage = e.getClass().getSimpleName();
                exception = e;
                throw new BatchJobException("Problem sending data to batch upload URL.", e);
            }
            catch (Throwable throwable) {
                this.logRequestResponse(requestXml, responseMessage, uploadUrl, "uploadBatchJobOperations", batchJobUploadResponse, exception);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BatchJobUploadResponse uploadIncrementalBatchJobOperations(BatchJobMutateRequestInterface request, final boolean isLastRequest, final BatchJobUploadStatus batchJobUploadStatus) throws BatchJobException {
        Preconditions.checkNotNull((Object)batchJobUploadStatus, (Object)"Null batch job upload status");
        Preconditions.checkNotNull((Object)batchJobUploadStatus.getResumableUploadUri(), (Object)"No resumable session URI");
        ByteArrayContent content = request.createBatchJobUploadBodyProvider().getHttpContent(request, batchJobUploadStatus.getTotalContentLength() == 0L, isLastRequest);
        String requestXml = null;
        String responseMessage = null;
        Throwable exception = null;
        BatchJobUploadResponse batchJobUploadResponse = null;
        final long contentLength = content.getLength();
        try {
            HttpRequestFactory requestFactory = this.httpTransport.createRequestFactory(new HttpRequestInitializer(){

                public void initialize(HttpRequest request) throws IOException {
                    HttpHeaders headers = BatchJobUploader.this.createHttpHeaders();
                    headers.setContentLength(Long.valueOf(contentLength));
                    headers.setContentRange(BatchJobUploader.this.constructContentRangeHeaderValue(contentLength, isLastRequest, batchJobUploadStatus));
                    request.setHeaders(headers);
                    request.setLoggingEnabled(true);
                }
            });
            HttpRequest httpRequest = requestFactory.buildPutRequest(new GenericUrl(batchJobUploadStatus.getResumableUploadUri()), (HttpContent)content);
            requestXml = Streams.readAll(content.getInputStream(), REQUEST_CHARSET);
            content.getInputStream().reset();
            HttpResponse response = httpRequest.execute();
            BatchJobUploadResponse batchJobUploadResponse2 = batchJobUploadResponse = new BatchJobUploadResponse(response, batchJobUploadStatus.getTotalContentLength() + httpRequest.getContent().getLength(), batchJobUploadStatus.getResumableUploadUri());
            this.logRequestResponse(requestXml, responseMessage, batchJobUploadStatus.getResumableUploadUri().toString(), "uploadIncrementalBatchJobOperations", batchJobUploadResponse, exception);
            return batchJobUploadResponse2;
        }
        catch (HttpResponseException e) {
            block6: {
                try {
                    if (e.getStatusCode() != 308) break block6;
                    BatchJobUploadResponse batchJobUploadResponse3 = batchJobUploadResponse = new BatchJobUploadResponse(new ByteArrayInputStream(new byte[0]), e.getStatusCode(), e.getStatusMessage(), batchJobUploadStatus.getTotalContentLength() + contentLength, batchJobUploadStatus.getResumableUploadUri());
                    this.logRequestResponse(requestXml, responseMessage, batchJobUploadStatus.getResumableUploadUri().toString(), "uploadIncrementalBatchJobOperations", batchJobUploadResponse, exception);
                    return batchJobUploadResponse3;
                }
                catch (Throwable throwable) {
                    this.logRequestResponse(requestXml, responseMessage, batchJobUploadStatus.getResumableUploadUri().toString(), "uploadIncrementalBatchJobOperations", batchJobUploadResponse, exception);
                    throw throwable;
                }
            }
            responseMessage = ((Object)((Object)e)).getClass().getSimpleName();
            exception = e;
            throw new BatchJobException("Failed response status from batch upload URL.", e);
            catch (IOException e2) {
                responseMessage = e2.getClass().getSimpleName();
                exception = e2;
                throw new BatchJobException("Problem sending data to batch upload URL.", e2);
            }
        }
    }

    private void logRequestResponse(String requestXml, String responseMessage, String url, String methodName, BatchJobUploadResponse batchJobUploadResponse, Throwable exception) {
        RequestInfo requestInfo = new RequestInfo.Builder().withServiceName(BatchJobUploader.class.getSimpleName()).withMethodName(methodName).withSoapRequestXml(requestXml).withUrl(url).build();
        ResponseInfo responseInfo = new ResponseInfo.Builder().withSoapResponseXml(String.format("<uploadResponse>%s</uploadResponse>", responseMessage)).build();
        SoapCallReturn soapCallReturn = new SoapCallReturn.Builder().withRequestInfo(requestInfo).withResponseInfo(responseInfo).withException(exception).withReturnValue(batchJobUploadResponse).build();
        this.serviceLoggers.logRequest(soapCallReturn);
        this.serviceLoggers.logSoapXml(soapCallReturn);
    }

    @VisibleForTesting
    String constructContentRangeHeaderValue(long requestLength, boolean isLastRequest, BatchJobUploadStatus batchJobUploadStatus) {
        long previousTotalLength;
        Preconditions.checkArgument((requestLength > 0L ? 1 : 0) != 0, (String)"Request length %s is <= 0", (Object[])new Object[]{requestLength});
        long contentLowerBound = previousTotalLength = batchJobUploadStatus.getTotalContentLength();
        long contentUpperBound = previousTotalLength + requestLength - 1L;
        String totalBytesString = isLastRequest ? String.valueOf(contentUpperBound + 1L) : "*";
        return String.format("bytes %d-%d/%s", contentLowerBound, contentUpperBound, totalBytesString);
    }
}

