/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.client;

import com.google.api.ads.adwords.lib.client.reporting.ReportingConfiguration;
import com.google.api.ads.common.lib.auth.OAuth2Compatible;
import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.conf.ConfigurationHelper;
import com.google.api.ads.common.lib.conf.ConfigurationLoadException;
import com.google.api.ads.common.lib.exception.ValidationException;
import com.google.api.client.auth.oauth2.Credential;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nullable;
import org.apache.commons.configuration.Configuration;

public class AdWordsSession
implements AdsSession,
OAuth2Compatible {
    private String clientCustomerId;
    private Long expressBusinessId;
    private String expressPlusPageId;
    private Boolean isValidateOnly;
    private Boolean isPartialFailure;
    private Credential oAuth2Credential;
    private ReportingConfiguration reportingConfiguration;
    private final String userAgent;
    private final String developerToken;
    private final String endpoint;
    public static final String DEFAULT_ENDPOINT = "https://adwords.google.com/";
    private static final String DEFAULT_USER_AGENT = "INSERT_USERAGENT_HERE";

    private AdWordsSession(Builder builder) {
        this.clientCustomerId = builder.clientCustomerId;
        this.developerToken = builder.developerToken;
        this.endpoint = builder.endpoint;
        this.isPartialFailure = builder.isPartialFailure;
        this.isValidateOnly = builder.isValidateOnly;
        this.oAuth2Credential = builder.oAuth2Credential;
        this.userAgent = builder.userAgent;
        this.reportingConfiguration = builder.reportingConfiguration;
    }

    public String getClientCustomerId() {
        return this.clientCustomerId;
    }

    public void setClientCustomerId(String clientCustomerId) {
        this.clientCustomerId = clientCustomerId;
    }

    @Nullable
    public Long getExpressBusinessId() {
        return this.expressBusinessId;
    }

    public void setExpressBusinessId(@Nullable Long businessId) {
        this.expressBusinessId = businessId;
    }

    @Nullable
    public String getExpressPlusPageId() {
        return this.expressPlusPageId;
    }

    public void setExpressPlusPageId(String expressPlusPageId) {
        this.expressPlusPageId = expressPlusPageId;
    }

    @Nullable
    public Boolean isValidateOnly() {
        return this.isValidateOnly;
    }

    public void setValidateOnly(@Nullable Boolean isValidateOnly) {
        this.isValidateOnly = isValidateOnly;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getDeveloperToken() {
        return this.developerToken;
    }

    @Nullable
    public Boolean isPartialFailure() {
        return this.isPartialFailure;
    }

    public void setPartialFailure(@Nullable Boolean isPartialFailure) {
        this.isPartialFailure = isPartialFailure;
    }

    @Override
    public Credential getOAuth2Credential() {
        return this.oAuth2Credential;
    }

    public void setOAuth2Credential(Credential oAuth2Credential) {
        Preconditions.checkNotNull((Object)oAuth2Credential, (Object)"oAuth2Credential cannot be null.");
        this.clearAuthentication();
        this.oAuth2Credential = oAuth2Credential;
    }

    @Nullable
    public ReportingConfiguration getReportingConfiguration() {
        return this.reportingConfiguration;
    }

    public void setReportingConfiguration(@Nullable ReportingConfiguration reportingConfiguration) {
        this.reportingConfiguration = reportingConfiguration;
    }

    private void clearAuthentication() {
        this.oAuth2Credential = null;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    public static class Builder
    implements com.google.api.ads.common.lib.utils.Builder<AdWordsSession> {
        private String endpoint;
        private String userAgent;
        private String developerToken;
        private String clientCustomerId;
        private Boolean isPartialFailure;
        private Boolean isValidateOnly;
        private Credential oAuth2Credential;
        private ReportingConfiguration reportingConfiguration;
        private final ConfigurationHelper configHelper = new ConfigurationHelper();

        public Builder fromFile() throws ConfigurationLoadException {
            return this.fromFile("ads.properties");
        }

        public Builder fromFile(String path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder fromFile(File path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder fromFile(URL path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder from(Configuration config) {
            this.clientCustomerId = config.getString("api.adwords.clientCustomerId", null);
            this.userAgent = config.getString("api.adwords.userAgent", null);
            this.developerToken = config.getString("api.adwords.developerToken", null);
            this.isPartialFailure = config.getBoolean("api.adwords.isPartialFailure", null);
            this.endpoint = config.getString("api.adwords.endpoint", null);
            Boolean isSkipReportHeader = config.getBoolean("api.adwords.reporting.skipHeader", null);
            Boolean isSkipColumnHeader = config.getBoolean("api.adwords.reporting.skipColumnHeader", null);
            Boolean isSkipReportSummary = config.getBoolean("api.adwords.reporting.skipSummary", null);
            if (isSkipReportHeader != null || isSkipColumnHeader != null || isSkipReportSummary != null) {
                this.reportingConfiguration = new ReportingConfiguration.Builder().skipReportHeader(isSkipReportHeader).skipColumnHeader(isSkipColumnHeader).skipReportSummary(isSkipReportSummary).build();
            }
            return this;
        }

        public Builder withOAuth2Credential(Credential oAuth2Credential) {
            this.clearAuthentication();
            this.oAuth2Credential = oAuth2Credential;
            return this;
        }

        public Builder withReportingConfiguration(ReportingConfiguration reportingConfiguration) {
            this.reportingConfiguration = reportingConfiguration;
            return this;
        }

        public Builder withDeveloperToken(String developerToken) {
            this.developerToken = developerToken;
            return this;
        }

        public Builder withUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder withEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder withClientCustomerId(String clientCustomerId) {
            this.clientCustomerId = clientCustomerId;
            return this;
        }

        public Builder enablePartialFailure() {
            this.isPartialFailure = true;
            return this;
        }

        private void clearAuthentication() {
            this.oAuth2Credential = null;
        }

        @Override
        public AdWordsSession build() throws ValidationException {
            this.defaultOptionals();
            this.validate();
            return new AdWordsSession(this);
        }

        private void defaultOptionals() {
            if (this.endpoint == null) {
                this.endpoint = AdWordsSession.DEFAULT_ENDPOINT;
            }
        }

        private void validate() throws ValidationException {
            if (this.oAuth2Credential == null) {
                throw new ValidationException("OAuth2 authentication must be used.", "");
            }
            if (this.developerToken == null) {
                throw new ValidationException("A developer token must be set.", "developerToken");
            }
            if (Strings.isNullOrEmpty((String)this.userAgent) || this.userAgent.contains(AdWordsSession.DEFAULT_USER_AGENT)) {
                throw new ValidationException(String.format("User agent must be set and not be the default [%s]", AdWordsSession.DEFAULT_USER_AGENT), "userAgent");
            }
            try {
                new URL(this.endpoint);
            }
            catch (MalformedURLException e) {
                throw new ValidationException(String.format("Endpoint [%s] not recognized as a valid URL.", this.endpoint), "endpoint", e);
            }
        }
    }
}

