/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils;

import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.utils.AdHocReportDownloadHelperInterface;
import com.google.api.ads.adwords.lib.utils.AdWordsInternals;
import com.google.api.ads.adwords.lib.utils.DetailedReportDownloadResponseException;
import com.google.api.ads.adwords.lib.utils.RawReportDownloadResponse;
import com.google.api.ads.adwords.lib.utils.ReportBodyProvider;
import com.google.api.ads.adwords.lib.utils.ReportBodyProviderFactory;
import com.google.api.ads.adwords.lib.utils.ReportDownloadResponse;
import com.google.api.ads.adwords.lib.utils.ReportDownloadResponseException;
import com.google.api.ads.adwords.lib.utils.ReportException;
import com.google.api.ads.adwords.lib.utils.ReportRequest;
import com.google.api.ads.adwords.lib.utils.ReportRequestFactoryHelper;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.ads.common.lib.utils.Streams;
import com.google.api.ads.common.lib.utils.XmlFieldExtractor;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.Map;

class AdHocReportDownloadHelperImpl
implements AdHocReportDownloadHelperInterface {
    private final AdWordsSession session;
    private final ReportRequestFactoryHelper reportRequestFactoryHelper;
    private final ReportBodyProviderFactory reportBodyProviderFactory;
    private final String version;

    AdHocReportDownloadHelperImpl(AdWordsSession session, String version) {
        this.session = session;
        this.version = version;
        this.reportRequestFactoryHelper = new ReportRequestFactoryHelper(session);
        this.reportBodyProviderFactory = new ReportBodyProviderFactory();
    }

    @Override
    public ReportDownloadResponse downloadReport(ReportRequest reportRequest, DetailedReportDownloadResponseException.Builder exceptionBuilder) throws ReportDownloadResponseException, ReportException {
        return this.handleResponse(this.downloadReport(reportRequest), exceptionBuilder);
    }

    @Override
    public RawReportDownloadResponse downloadReport(ReportRequest reportRequest) throws ReportException {
        try {
            String downloadUrl = this.generateReportUrl(this.version);
            HttpRequestFactory requestFactory = this.reportRequestFactoryHelper.getHttpRequestFactory(downloadUrl, this.version);
            ReportBodyProvider reportBodyProvider = this.reportBodyProviderFactory.getReportBodyProvider(reportRequest);
            HttpRequest httpRequest = requestFactory.buildPostRequest(new GenericUrl(downloadUrl), reportBodyProvider.getHttpContent());
            HttpResponse response = httpRequest.execute();
            Charset charSet = REPORT_CHARSET;
            if (response.getMediaType() != null && response.getMediaType().getCharsetParameter() != null) {
                charSet = response.getMediaType().getCharsetParameter();
            }
            return new RawReportDownloadResponse(response.getStatusCode(), response.getContent(), charSet, reportRequest.getDownloadFormat().name());
        }
        catch (MalformedURLException e) {
            throw new ReportException("Created invalid report download URL.", e);
        }
        catch (IOException e) {
            throw new ReportException("Problem sending data to report download server.", e);
        }
        catch (AuthenticationException e) {
            throw new ReportException("Problem with OAuth authorization.", e);
        }
    }

    @Override
    public ReportDownloadResponse handleResponse(RawReportDownloadResponse rawResponse, DetailedReportDownloadResponseException.Builder exceptionBuilder) throws ReportDownloadResponseException {
        String responseText;
        Preconditions.checkNotNull((Object)rawResponse, (Object)"Null response");
        Preconditions.checkNotNull((Object)exceptionBuilder, (Object)"Null exception builder");
        if (rawResponse.getHttpStatus() == 200) {
            return new ReportDownloadResponse(rawResponse);
        }
        if (rawResponse.getInputStream() == null) {
            responseText = "";
        } else {
            try {
                responseText = Streams.readAll(rawResponse.getInputStream(), rawResponse.getCharset());
            }
            catch (IOException e1) {
                throw new ReportDownloadResponseException(rawResponse.getHttpStatus(), (Throwable)e1);
            }
        }
        DetailedReportDownloadResponseException exception = exceptionBuilder.build(rawResponse.getHttpStatus(), responseText);
        XmlFieldExtractor extractor = AdWordsInternals.getInstance().getXmlFieldExtractor();
        Map<String, String> fields = extractor.extract(new ByteArrayInputStream(responseText.getBytes()), new String[]{"fieldPath", "trigger", "type"});
        exception.setFieldPath(fields.get("fieldPath"));
        exception.setTrigger(fields.get("trigger"));
        exception.setType(fields.get("type"));
        throw exception;
    }

    private String generateReportUrl(String version) {
        return this.session.getEndpoint() + "/api/adwords/reportdownload" + '/' + version;
    }

    @Override
    public int getReportDownloadTimeout() {
        return this.reportRequestFactoryHelper.getReportDownloadTimeout();
    }

    @Override
    public void setReportDownloadTimeout(int reportDownloadTimeout) {
        this.reportRequestFactoryHelper.setReportDownloadTimeout(reportDownloadTimeout);
    }
}

