/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.utils.logging;

import com.google.api.ads.common.lib.utils.logging.AdsServiceLoggers;
import com.google.api.ads.common.lib.utils.logging.PrettyPrinter;
import com.google.api.ads.common.lib.utils.logging.PrettyPrinterInterface;
import com.google.common.base.Supplier;
import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingModule
extends AbstractModule {
    private final String loggerPrefix;

    public LoggingModule(String loggerPrefix) {
        this.loggerPrefix = loggerPrefix;
    }

    protected void configure() {
        this.bind(AdsServiceLoggers.class);
        this.bind((TypeLiteral)new TypeLiteral<Supplier<DocumentBuilder>>(){}).to(DocumentBuilderSupplier.class);
        this.bind((TypeLiteral)new TypeLiteral<Supplier<Transformer>>(){}).to(TransformerSupplier.class);
        this.bind((TypeLiteral)new TypeLiteral<Supplier<XPath>>(){}).to(XPathSupplier.class);
        this.bind(PrettyPrinterInterface.class).to(PrettyPrinter.class);
        this.bind(Logger.class).annotatedWith((Annotation)Names.named((String)"libLogger")).toInstance((Object)AdsServiceLoggers.ADS_API_LIB_LOG);
        this.configureLogger(this.loggerPrefix, "soapXmlLogger");
        this.configureLogger(this.loggerPrefix, "requestInfoLogger");
    }

    protected void configureLogger(String prefix, String name) {
        this.bind(Logger.class).annotatedWith((Annotation)Names.named((String)name)).toProvider((Provider)new LoggerProvider(prefix, name)).asEagerSingleton();
    }

    private static final class LoggerProvider
    implements Provider<Logger> {
        private final String loggerPrefix;
        private final String logType;

        public LoggerProvider(String loggerPrefix, String logType) {
            this.loggerPrefix = loggerPrefix;
            this.logType = logType;
        }

        public Logger get() {
            String string = this.loggerPrefix;
            String string2 = this.logType;
            return LoggerFactory.getLogger((String)new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).toString());
        }
    }

    @ThreadSafe
    private static final class TransformerSupplier
    implements Supplier<Transformer> {
        private TransformerSupplier() {
        }

        public Transformer get() {
            Transformer transformer;
            try {
                transformer = TransformerFactory.newInstance().newTransformer();
            }
            catch (TransformerConfigurationException e) {
                String string = String.valueOf(e);
                AdsServiceLoggers.ADS_API_LIB_LOG.warn(new StringBuilder(41 + String.valueOf(string).length()).append("Unable to initialize Transformer. Error: ").append(string).toString());
                return null;
            }
            catch (TransformerFactoryConfigurationError e) {
                String string = String.valueOf(e);
                AdsServiceLoggers.ADS_API_LIB_LOG.warn(new StringBuilder(41 + String.valueOf(string).length()).append("Unable to initialize Transformer. Error: ").append(string).toString());
                return null;
            }
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            return transformer;
        }
    }

    @ThreadSafe
    private static final class DocumentBuilderSupplier
    implements Supplier<DocumentBuilder> {
        private DocumentBuilderSupplier() {
        }

        public DocumentBuilder get() {
            try {
                return DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                String string = String.valueOf(e);
                AdsServiceLoggers.ADS_API_LIB_LOG.warn(new StringBuilder(45 + String.valueOf(string).length()).append("Unable to initialize DocumentBuilder. Error: ").append(string).toString());
                return null;
            }
        }
    }

    @ThreadSafe
    private static final class XPathSupplier
    implements Supplier<XPath> {
        private XPathSupplier() {
        }

        public XPath get() {
            return XPathFactory.newInstance().newXPath();
        }
    }
}

