/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.soap;

import com.google.api.ads.common.lib.soap.SoapCall;
import com.google.api.ads.common.lib.soap.SoapClientHandlerInterface;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;

public abstract class SoapClientHandler<T>
implements SoapClientHandlerInterface<T> {
    protected SoapClientHandler() {
    }

    protected Object[] processSoapArguments(Method soapClientMethod, Object[] args) {
        ArrayList argsList = new ArrayList();
        if (args == null) {
            return null;
        }
        Collections.addAll(argsList, args);
        for (int curretNumArgs = argsList.size(); curretNumArgs < soapClientMethod.getParameterTypes().length; ++curretNumArgs) {
            argsList.add(null);
        }
        return argsList.toArray(new Object[0]);
    }

    @Override
    public Method getSoapClientMethod(T soapClient, Method method) throws NoSuchMethodException {
        for (Method soapClientMethod : soapClient.getClass().getMethods()) {
            if (!method.getName().equals(soapClientMethod.getName()) || !method.getReturnType().equals(soapClientMethod.getReturnType())) continue;
            return soapClientMethod;
        }
        String string = String.valueOf(method.getName());
        String string2 = String.valueOf(method.getReturnType());
        throw new NoSuchMethodException(new StringBuilder(41 + String.valueOf(string).length() + String.valueOf(string2).length()).append("No method named ").append(string).append(" with return type ").append(string2).append(" found.").toString());
    }

    protected Object invoke(SoapCall<T> soapCall) throws Exception {
        Method soapClientMethod = soapCall.getSoapClientMethod();
        Object[] soapArgs = soapCall.getSoapArgs();
        soapArgs = this.processSoapArguments(soapClientMethod, soapArgs);
        return soapClientMethod.invoke(soapCall.getSoapClient(), soapArgs);
    }
}

