/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils;

import com.google.api.ads.adwords.lib.utils.AwqlReportBodyProvider;
import com.google.api.ads.adwords.lib.utils.ReportBodyProvider;
import com.google.api.ads.adwords.lib.utils.ReportDefinitionBodyProvider;
import com.google.api.ads.adwords.lib.utils.ReportRequest;
import com.google.common.base.Preconditions;

class ReportBodyProviderFactory {
    ReportBodyProviderFactory() {
    }

    ReportBodyProvider getReportBodyProvider(ReportRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"Null request");
        Preconditions.checkNotNull((Object)((Object)request.getRequestType()), (Object)"Null request type");
        switch (request.getRequestType()) {
            case AWQL: {
                return new AwqlReportBodyProvider(request.getReportRequestString(), request.getDownloadFormat().name());
            }
            case XML: {
                return new ReportDefinitionBodyProvider(request.getReportRequestString());
            }
        }
        String string = String.valueOf((Object)request.getRequestType());
        throw new IllegalArgumentException(new StringBuilder(27 + String.valueOf(string).length()).append("Unrecognized request type: ").append(string).toString());
    }
}

