/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.factory;

import com.google.api.ads.common.lib.client.AdsServiceClient;
import com.google.api.ads.common.lib.client.AdsServiceDescriptor;
import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.factory.helper.AdsServiceClientFactoryHelper;
import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.FactoryProvider;

public class FactoryModule<C extends AdsServiceClient<S, D>, D extends AdsServiceDescriptor, S extends AdsSession, H extends AdsServiceClientFactoryHelper<C, S, D>>
extends AbstractModule {
    private final TypeLiteral adsServiceClientFactoryTypeLiteral;
    private final TypeLiteral adsServiceDescriptorFactoryTypeLiteral;
    private final TypeLiteral adsServiceClientTypeLiteral;
    private final TypeLiteral adsServiceDescriptorTypeLiteral;
    private final Class<H> factoryHelperClass;
    private final Class<?> factoryClass;

    public FactoryModule(TypeLiteral adsServiceClientFactoryTypeLiteral, TypeLiteral adsServiceDescriptorFactoryTypeLiteral, TypeLiteral adsServiceClientTypeLiteral, TypeLiteral adsServiceDescriptorTypeLiteral, Class<H> factoryHelperClass, Class<?> factoryClass) {
        this.adsServiceClientFactoryTypeLiteral = adsServiceClientFactoryTypeLiteral;
        this.adsServiceDescriptorFactoryTypeLiteral = adsServiceDescriptorFactoryTypeLiteral;
        this.adsServiceClientTypeLiteral = adsServiceClientTypeLiteral;
        this.adsServiceDescriptorTypeLiteral = adsServiceDescriptorTypeLiteral;
        this.factoryHelperClass = factoryHelperClass;
        this.factoryClass = factoryClass;
    }

    protected void configure() {
        this.bind(this.adsServiceClientFactoryTypeLiteral).toProvider(FactoryProvider.newFactory((TypeLiteral)this.adsServiceClientFactoryTypeLiteral, (TypeLiteral)this.adsServiceClientTypeLiteral));
        this.bind(this.adsServiceDescriptorFactoryTypeLiteral).toProvider(FactoryProvider.newFactory((TypeLiteral)this.adsServiceDescriptorFactoryTypeLiteral, (TypeLiteral)this.adsServiceDescriptorTypeLiteral));
        this.bind(AdsServiceClientFactoryHelper.class).to(this.factoryHelperClass);
        this.bind(this.factoryClass);
    }

    public static interface AdsServiceClientFactoryInterface<C extends AdsServiceClient<S, D>, S extends AdsSession, D extends AdsServiceDescriptor> {
        public C create(@Assisted(value="soapClient") Object var1, @Assisted(value="adsServiceDescriptor") D var2, @Assisted(value="adsSession") S var3);
    }

    public static interface AdsServiceDescriptorFactoryInterface<D extends AdsServiceDescriptor> {
        public D create(@Assisted(value="interfaceClass") Class<?> var1, @Assisted(value="version") String var2);
    }
}

