/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.utils;

import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public final class Streams {
    private Streams() {
    }

    public static InputStream wrapString(String str) {
        try {
            return new ByteArrayInputStream(str.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("UTF-8 should be supported.");
        }
    }

    public static String readAll(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Streams.copy(inputStream, byteArrayOutputStream);
        return new String(byteArrayOutputStream.toByteArray());
    }

    public static void write(String str, final OutputStream outputStream) throws IOException {
        ByteStreams.write((byte[])str.getBytes(), (OutputSupplier)new OutputSupplier<OutputStream>(){

            public OutputStream getOutput() {
                return outputStream;
            }
        });
    }

    public static void copy(final InputStream inputStream, final OutputStream outputStream) throws IOException {
        ByteStreams.copy((InputSupplier)new InputSupplier<InputStream>(){

            public InputStream getInput() {
                return inputStream;
            }
        }, (OutputSupplier)new OutputSupplier<OutputStream>(){

            public OutputStream getOutput() {
                return outputStream;
            }
        });
    }
}

