/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.conf;

import com.google.api.ads.common.lib.conf.AdsApiConfiguration;
import com.google.api.ads.common.lib.conf.AdsLibConfiguration;
import com.google.api.ads.common.lib.conf.ConfigurationHelper;
import com.google.api.ads.common.lib.conf.ConfigurationProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.configuration.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigurationModule
extends AbstractModule {
    private final String BUILD_PROPERTIES = "props/google-ads-api-java-build.properties";
    private final ConfigurationHelper configurationHelper;

    public ConfigurationModule() {
        this.configurationHelper = new ConfigurationHelper();
    }

    @VisibleForTesting
    ConfigurationModule(ConfigurationHelper configurationHelper) {
        this.configurationHelper = configurationHelper;
    }

    protected void configure() {
    }

    protected void configureConfigurations(Class<? extends AdsApiConfiguration> apiConfigurationClass, @Nullable List<URL> apiPropertyUrls, @Nullable List<String> apiPropertyFilePaths, Class<? extends AdsLibConfiguration> adsLibConfigurationClass, @Nullable List<URL> libPropertyUrls, @Nullable List<String> libPropertyFilePaths, List<URL> productPropertyUrls) {
        this.bind(AdsApiConfiguration.class).to(apiConfigurationClass).asEagerSingleton();
        this.bind(AdsLibConfiguration.class).to(adsLibConfigurationClass).asEagerSingleton();
        this.bind(Configuration.class).annotatedWith((Annotation)Names.named((String)"api")).toProvider((Provider)new ConfigurationProvider(ConfigurationHelper.newList(apiPropertyUrls, false), ConfigurationHelper.newList(apiPropertyFilePaths, true)));
        this.bind(Configuration.class).annotatedWith((Annotation)Names.named((String)"lib")).toProvider((Provider)new ConfigurationProvider(ConfigurationHelper.newList(libPropertyUrls, false), ConfigurationHelper.newList(libPropertyFilePaths, true)));
        this.bind(Configuration.class).annotatedWith((Annotation)Names.named((String)"build")).toProvider((Provider)new ConfigurationProvider(ConfigurationHelper.newList(Lists.newArrayList((Object[])new URL[]{ConfigurationModule.class.getResource("props/google-ads-api-java-build.properties")}), false), ConfigurationHelper.newList(Lists.newArrayList((Object[])new String[]{"google-ads-api-java-build.properties"}), true)));
        this.bind(Configuration.class).annotatedWith((Annotation)Names.named((String)"product")).toProvider((Provider)new ConfigurationProvider(ConfigurationHelper.newList(productPropertyUrls, false), null));
    }
}

