/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfa.lib.client;

import com.google.api.ads.common.lib.client.AdsServiceClient;
import com.google.api.ads.common.lib.client.HeaderHandler;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.SoapCall;
import com.google.api.ads.common.lib.soap.SoapCallReturn;
import com.google.api.ads.common.lib.soap.SoapClientHandlerInterface;
import com.google.api.ads.common.lib.utils.logging.AdsServiceLoggers;
import com.google.api.ads.dfa.lib.auth.LoginTokenException;
import com.google.api.ads.dfa.lib.auth.LoginTokens;
import com.google.api.ads.dfa.lib.auth.TokenExpirationDetector;
import com.google.api.ads.dfa.lib.client.DfaServiceDescriptor;
import com.google.api.ads.dfa.lib.client.DfaSession;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfaServiceClient
extends AdsServiceClient<DfaSession, DfaServiceDescriptor> {
    private final TokenExpirationDetector tokenExpirationDetector;
    private final LoginTokens loginTokens;

    @Inject
    public DfaServiceClient(@Assisted(value="soapClient") Object soapClient, @Assisted(value="adsServiceDescriptor") DfaServiceDescriptor dfaServiceDescriptor, @Assisted(value="adsSession") DfaSession dfaSession, SoapClientHandlerInterface soapClientHandler, HeaderHandler dfaHeaderHandler, AdsServiceLoggers adsServiceLoggers, TokenExpirationDetector tokenExpirationDetector, LoginTokens loginTokens) throws ServiceException {
        super(soapClient, dfaSession, dfaServiceDescriptor, soapClientHandler, dfaHeaderHandler, adsServiceLoggers);
        this.tokenExpirationDetector = tokenExpirationDetector;
        this.loginTokens = loginTokens;
    }

    @Override
    protected synchronized SoapCallReturn callSoapClient(SoapCall<Object> soapCall) {
        SoapCallReturn soapCallReturn = super.callSoapClient(soapCall);
        if (this.tokenExpirationDetector.isTokenExpiredException(soapCallReturn.getException())) {
            try {
                ((DfaSession)this.getAdsSession()).setToken(this.loginTokens.generateToken(((DfaServiceDescriptor)this.getAdsServiceDescriptor()).getInterfaceClass().getPackage().getName(), (DfaSession)this.getAdsSession()));
                this.setHeaders();
            }
            catch (LoginTokenException loginTokenException) {
                return soapCallReturn;
            }
            catch (ServiceException serviceException) {
                return soapCallReturn;
            }
            catch (AuthenticationException authenticationException) {
                return soapCallReturn;
            }
            soapCallReturn = super.callSoapClient(soapCall);
        }
        return soapCallReturn;
    }
}

