/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfa.lib.client;

import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.client.Endpoint;
import com.google.api.ads.common.lib.conf.ConfigurationHelper;
import com.google.api.ads.common.lib.exception.ValidationException;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.configuration.Configuration;

public class DfaSession
implements AdsSession {
    private String username;
    private String password;
    private String authenticationToken;
    private String applicationName;
    private String endpoint;

    private DfaSession() {
    }

    private DfaSession(DfaSession copy) {
        this.applicationName = copy.applicationName;
        this.authenticationToken = copy.authenticationToken;
        this.endpoint = copy.endpoint;
        this.password = copy.password;
        this.username = copy.username;
    }

    public void setToken(String token) {
        this.authenticationToken = token;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getToken() {
        return this.authenticationToken;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public boolean isEnvironment(Endpoint environment) {
        return environment.getEndpoint().equals(this.endpoint);
    }

    /* synthetic */ DfaSession(DfaSession dfaSession, DfaSession dfaSession2) {
        this();
    }

    /* synthetic */ DfaSession(DfaSession dfaSession, DfaSession dfaSession2, DfaSession dfaSession3) {
        this(dfaSession);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements com.google.api.ads.common.lib.utils.Builder<DfaSession> {
        private DfaSession dfaSession = new DfaSession(null, null);
        private String environmentString;
        @VisibleForTesting
        ConfigurationHelper configHelper;

        @VisibleForTesting
        Builder(ConfigurationHelper helper) {
            this.configHelper = helper;
        }

        public Builder() {
            this.configHelper = new ConfigurationHelper();
        }

        public Builder fromFile() {
            return this.fromFile("ads.properties");
        }

        public Builder fromFile(String path) {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder fromFile(File path) {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder fromFile(URL path) {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder from(Configuration config) {
            this.dfaSession.username = config.getString("api.dfa.username", null);
            this.dfaSession.password = config.getString("api.dfa.password", null);
            this.dfaSession.applicationName = config.getString("api.dfa.applicationName", null);
            this.dfaSession.authenticationToken = config.getString("api.dfa.token", null);
            this.dfaSession.endpoint = config.getString("api.dfa.endpoint", null);
            this.environmentString = config.getString("api.dfa.environment", null);
            return this;
        }

        public Builder withEnvironment(Environment environment) {
            this.dfaSession.endpoint = environment.getEndpoint();
            this.environmentString = null;
            return this;
        }

        public Builder withEndpoint(String endpoint) {
            this.dfaSession.endpoint = endpoint;
            this.environmentString = null;
            return this;
        }

        public Builder withUsernameAndPassword(String username, String password) {
            this.dfaSession.username = username;
            this.dfaSession.password = password;
            return this;
        }

        public Builder withUsernameAndToken(String username, String token) {
            this.dfaSession.username = username;
            this.dfaSession.authenticationToken = token;
            return this;
        }

        public Builder withApplicationName(String applicationName) {
            this.dfaSession.applicationName = applicationName;
            return this;
        }

        @Override
        public DfaSession build() throws ValidationException {
            this.validate(this.dfaSession);
            return new DfaSession(this.dfaSession, null, null);
        }

        private void validate(DfaSession dfaSession) throws ValidationException {
            boolean usingToken;
            if (this.environmentString != null) {
                try {
                    this.withEnvironment(Environment.valueOf(this.environmentString.toUpperCase()));
                }
                catch (IllegalArgumentException e) {
                    throw new ValidationException(String.format("Environment [%s] not recognized.", this.environmentString), "api.dfa.environment", e);
                }
            }
            if (dfaSession.getUsername() == null) {
                throw new ValidationException("Username is required.", "username");
            }
            boolean usingPassword = dfaSession.getPassword() != null;
            boolean bl = usingToken = dfaSession.getToken() != null;
            if (!usingPassword && !usingToken) {
                throw new ValidationException("Either username/password or username/token must be used.", "");
            }
            if (usingPassword && usingToken) {
                throw new ValidationException("Both username/password and username/token cannot be used at the same time.", "");
            }
            try {
                new URL(dfaSession.getEndpoint());
            }
            catch (MalformedURLException e) {
                throw new ValidationException("Endpoint is required and must be a valid URL.", "endpoint", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Environment implements Endpoint
    {
        PRODUCTION("https://advertisersapi.doubleclick.net"),
        TEST("https://advertisersapitest.doubleclick.net");

        private final String endpoint;

        private Environment(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public String getEndpoint() {
            return this.endpoint;
        }
    }
}

