/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfa.lib.client;

import com.google.api.ads.common.lib.client.HeaderHandler;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.SoapClientHandlerInterface;
import com.google.api.ads.dfa.lib.auth.LoginTokenException;
import com.google.api.ads.dfa.lib.auth.LoginTokens;
import com.google.api.ads.dfa.lib.client.DfaServiceDescriptor;
import com.google.api.ads.dfa.lib.client.DfaSession;
import com.google.api.ads.dfa.lib.conf.DfaApiConfiguration;
import com.google.api.ads.dfa.lib.conf.DfaBuildConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfaAxisHeaderHandler
implements HeaderHandler<DfaSession, DfaServiceDescriptor> {
    private static final String WSSE_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private final SoapClientHandlerInterface<Object> soapClientHandler;
    private final DfaApiConfiguration dfaApiConfiguration;
    private final DfaBuildConfiguration dfaBuildConfiguration;
    private final LoginTokens loginTokens;

    @Inject
    public DfaAxisHeaderHandler(SoapClientHandlerInterface soapClientHandler, DfaApiConfiguration dfaApiConfiguration, LoginTokens loginTokens, DfaBuildConfiguration dfaBuildConfiguration) {
        this.soapClientHandler = soapClientHandler;
        this.dfaApiConfiguration = dfaApiConfiguration;
        this.loginTokens = loginTokens;
        this.dfaBuildConfiguration = dfaBuildConfiguration;
    }

    @Override
    public void setHeaders(Object soapClient, DfaSession dfaSession, DfaServiceDescriptor dfaServiceDescriptor) throws AuthenticationException, ServiceException {
        if (!dfaServiceDescriptor.getInterfaceClass().toString().endsWith("LoginRemote")) {
            String username = dfaSession.getUsername();
            String token = dfaSession.getToken();
            if (token == null) {
                token = this.generateAuthToken(dfaServiceDescriptor, dfaSession);
                dfaSession.setToken(token);
            }
            this.setWsseSecurityHeader(soapClient, username, token);
        }
        this.setRequestHeader(soapClient, dfaSession);
    }

    private void setWsseSecurityHeader(Object soapClient, String username, String token) {
        try {
            QName securityNode = new QName(WSSE_NAMESPACE, "UsernameToken");
            SOAPHeaderElement usernameToken = this.soapClientHandler.createSoapHeaderElement(securityNode);
            this.setHeaderElement(usernameToken, "Username", username);
            this.setHeaderElement(usernameToken, "Password", token);
            usernameToken.setActor("");
            this.soapClientHandler.setHeader(soapClient, WSSE_NAMESPACE, "Security", usernameToken);
        }
        catch (SOAPException e) {
            throw new ServiceException("Could not set WSSE security header.", e);
        }
    }

    private void setRequestHeader(Object soapClient, DfaSession dfaSession) {
        try {
            String namespace = this.dfaApiConfiguration.getNamespacePrefix();
            QName requestHeaderNode = new QName(namespace, "applicationName");
            SOAPHeaderElement appNameToken = this.soapClientHandler.createSoapHeaderElement(requestHeaderNode);
            appNameToken.addTextNode(String.valueOf(this.generateLibSignature()) + "|" + dfaSession.getApplicationName());
            appNameToken.setActor("");
            this.soapClientHandler.setHeader(soapClient, namespace, "RequestHeader", appNameToken);
        }
        catch (SOAPException e) {
            throw new ServiceException("Could not set application name header.", e);
        }
    }

    String generateLibSignature() {
        return String.valueOf(this.dfaBuildConfiguration.getLibPrefix()) + "-" + this.dfaBuildConfiguration.getLibPostfix() + "-" + this.dfaBuildConfiguration.getLibVersion();
    }

    @VisibleForTesting
    protected String generateAuthToken(DfaServiceDescriptor dfaServiceDescriptor, DfaSession dfaSession) throws LoginTokenException {
        return this.loginTokens.generateToken(dfaServiceDescriptor.getInterfaceClass().getPackage().getName(), dfaSession);
    }

    private void setHeaderElement(SOAPHeaderElement usernameToken, String headerName, String headerValue) throws SOAPException {
        SOAPElement usernameNode = usernameToken.addChildElement(headerName);
        usernameNode.addTextNode(headerValue);
    }
}

