/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils;

import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.utils.ReportDownloadResponse;
import com.google.api.ads.adwords.lib.utils.ReportException;
import com.google.api.ads.adwords.lib.utils.ReportUrlConnectionHelper;
import com.google.api.ads.common.lib.utils.Streams;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdHocReportDownloadHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)(String.valueOf(AdHocReportDownloadHelper.class.getPackage().getName()) + ".report_download"));
    private static final String ERROR_MESSAGE_REGEX = "^.*!!![^|]*\\|\\|\\|([^|]*)\\|\\|\\|([^?]*)\\?\\?\\?.*$";
    private static final int ERROR_MESSAGE_GROUP = 2;
    private final AdWordsSession session;
    private final ReportUrlConnectionHelper reportUrlConnectionHelper;
    private final String version;

    public AdHocReportDownloadHelper(AdWordsSession session, String version) {
        this.session = session;
        this.version = version;
        this.reportUrlConnectionHelper = new ReportUrlConnectionHelper(session);
    }

    public ReportDownloadResponse downloadReport(String reportDefinitionXml) throws ReportException {
        try {
            String downloadUrl = this.generateReportUrl(this.version);
            HttpURLConnection conn = this.reportUrlConnectionHelper.getReportHttpUrlConnection(downloadUrl);
            conn.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            logger.info("Content-type: {}", (Object)"application/x-www-form-urlencoded");
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            this.writeReportToStream(conn.getOutputStream(), reportDefinitionXml);
            logger.info(reportDefinitionXml);
            int status = conn.getResponseCode();
            String responseMessage = "SUCCESS";
            InputStream inputStream = null;
            if (status == 200) {
                inputStream = conn.getInputStream();
                logger.info(conn.getResponseMessage());
                this.logResponseHeaders(conn.getHeaderFields(), true);
            } else {
                logger.warn(conn.getResponseMessage());
                this.logResponseHeaders(conn.getHeaderFields(), false);
                responseMessage = Streams.readAll(conn.getErrorStream());
                Matcher matcher = Pattern.compile(ERROR_MESSAGE_REGEX).matcher(responseMessage);
                if (matcher.matches()) {
                    responseMessage = matcher.group(2);
                }
                logger.warn(responseMessage);
            }
            return new ReportDownloadResponse(status, responseMessage, inputStream);
        }
        catch (MalformedURLException e) {
            throw new ReportException("Created invalid report download URL.", e);
        }
        catch (IOException e) {
            throw new ReportException("Problem sending data to report download server.", e);
        }
    }

    @VisibleForTesting
    void logResponseHeaders(Map<String, List<String>> headerFields, boolean success) {
        for (Map.Entry<String, List<String>> header : headerFields.entrySet()) {
            String headerName = header.getKey();
            for (String value : header.getValue()) {
                if (success) {
                    logger.info("{}: {}", (Object)headerName, (Object)value);
                    continue;
                }
                logger.warn("{}: {}", (Object)headerName, (Object)value);
            }
        }
    }

    @VisibleForTesting
    void writeReportToStream(OutputStream outputStream, String reportDefinitionXml) throws UnsupportedEncodingException, IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        writer.write("__rdxml=" + URLEncoder.encode(reportDefinitionXml, "UTF-8"));
        writer.close();
    }

    @VisibleForTesting
    String generateReportUrl(String version) {
        return String.valueOf(this.session.getEndpoint()) + "/api/adwords/reportdownload" + '/' + version;
    }
}

