/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfp.lib.client;

import com.google.api.ads.common.lib.client.AdsServiceDescriptor;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.compatability.AxisCompatible;
import com.google.api.ads.common.lib.soap.compatability.JaxWsCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.net.MalformedURLException;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfpServiceDescriptor
implements AdsServiceDescriptor,
AxisCompatible,
JaxWsCompatible {
    private final Class<?> interfaceClass;
    private final String version;

    @Inject
    public DfpServiceDescriptor(@Assisted(value="interfaceClass") Class<?> interfaceClass, @Assisted(value="version") String version) {
        this.interfaceClass = interfaceClass;
        this.version = version;
    }

    @Override
    public Class<?> getInterfaceClass() throws ServiceException {
        return this.interfaceClass;
    }

    @Override
    public String getEndpointAddress(String endpointServer) throws MalformedURLException {
        String serviceName = this.getServiceName();
        String endpointServerUrl = new URL(endpointServer).toString();
        if (endpointServerUrl.endsWith("/")) {
            endpointServerUrl = endpointServerUrl.substring(0, endpointServerUrl.length() - 1);
        }
        return String.valueOf(endpointServerUrl) + "/apis/ads/publisher/" + this.version + "/" + serviceName;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Class<?> getLocatorClass() throws ClassNotFoundException {
        return Class.forName(String.valueOf(this.interfaceClass.getPackage().getName()) + "." + this.getServiceName() + "Locator");
    }

    @VisibleForTesting
    String getServiceName() {
        String simpleName = this.interfaceClass.getSimpleName();
        return simpleName.substring(0, simpleName.indexOf("Interface"));
    }

    @Override
    public Class<?> getServiceClass() throws ClassNotFoundException {
        return Class.forName(String.valueOf(this.interfaceClass.getPackage().getName()) + "." + this.getServiceName());
    }
}

