/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.auth;

import com.google.api.ads.common.lib.auth.ClientLoginCompatible;
import com.google.api.ads.common.lib.auth.OAuth2AuthorizationHeaderProvider;
import com.google.api.ads.common.lib.auth.OAuth2Compatible;
import com.google.api.ads.common.lib.auth.OAuth2Helper;
import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.conf.AdsLibConfiguration;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.ads.common.lib.exception.OAuthException;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.io.IOException;
import javax.annotation.Nullable;

public class AuthorizationHeaderProvider {
    @VisibleForTesting
    static final String CLIENT_LOGIN_HEADER_PREFIX = "GoogleLogin auth=";
    private final OAuth2AuthorizationHeaderProvider oAuth2AuthorizationHeaderProvider;
    private final AdsLibConfiguration adsLibConfiguration;
    private final OAuth2Helper oAuth2Helper;

    @Inject
    public AuthorizationHeaderProvider(OAuth2AuthorizationHeaderProvider oAuth2AuthorizationHeaderProvider, AdsLibConfiguration adsLibConfiguration, OAuth2Helper oAuth2Helper) {
        this.oAuth2AuthorizationHeaderProvider = oAuth2AuthorizationHeaderProvider;
        this.adsLibConfiguration = adsLibConfiguration;
        this.oAuth2Helper = oAuth2Helper;
    }

    public String getAuthorizationHeader(AdsSession adsSession, @Nullable String endpointUrl) throws AuthenticationException {
        if (adsSession instanceof OAuth2Compatible && ((OAuth2Compatible)((Object)adsSession)).getOAuth2Credential() != null) {
            return this.getOAuth2Header((OAuth2Compatible)((Object)adsSession));
        }
        if (adsSession instanceof ClientLoginCompatible && ((ClientLoginCompatible)((Object)adsSession)).getClientLoginToken() != null) {
            return this.getClientLoginHeader((ClientLoginCompatible)((Object)adsSession));
        }
        throw new IllegalArgumentException("Session does not have any valid authentication mechanisms");
    }

    private String getClientLoginHeader(ClientLoginCompatible adsSession) {
        return CLIENT_LOGIN_HEADER_PREFIX + adsSession.getClientLoginToken();
    }

    private String getOAuth2Header(OAuth2Compatible oAuth2Compatible) throws OAuthException {
        if (this.adsLibConfiguration.isAutoRefreshOAuth2TokenEnabled()) {
            try {
                this.oAuth2Helper.refreshCredential(oAuth2Compatible.getOAuth2Credential());
            }
            catch (IOException e) {
                throw new OAuthException("OAuth2 token could not be refreshed.", e);
            }
        }
        return this.oAuth2AuthorizationHeaderProvider.getOAuth2AuthorizationHeader(oAuth2Compatible);
    }
}

