/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.factory.helper;

import com.google.api.ads.common.lib.client.AdsServiceClient;
import com.google.api.ads.common.lib.client.AdsServiceDescriptor;
import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.factory.FactoryModule;
import com.google.api.ads.common.lib.factory.helper.AdsServiceClientFactoryHelper;
import com.google.api.ads.common.lib.soap.SoapClientHandlerInterface;
import com.google.api.ads.common.lib.soap.SoapServiceClient;
import com.google.api.ads.common.lib.soap.SoapServiceDescriptor;
import com.google.common.annotations.VisibleForTesting;
import java.net.MalformedURLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseAdsServiceClientFactoryHelper<C extends AdsServiceClient<S, D>, S extends AdsSession, D extends AdsServiceDescriptor>
implements AdsServiceClientFactoryHelper<C, S, D> {
    private final FactoryModule.AdsServiceClientFactoryInterface<C, S, D> adsServiceClientFactory;
    private final FactoryModule.AdsServiceDescriptorFactoryInterface<D> adsServiceDescriptorFactory;
    private final SoapClientHandlerInterface<?> soapClientHandler;

    public BaseAdsServiceClientFactoryHelper(FactoryModule.AdsServiceClientFactoryInterface<C, S, D> adsServiceClientFactory, FactoryModule.AdsServiceDescriptorFactoryInterface<D> adsServiceDescriptorFactory, SoapClientHandlerInterface<?> soapClientHandler) {
        this.adsServiceClientFactory = adsServiceClientFactory;
        this.adsServiceDescriptorFactory = adsServiceDescriptorFactory;
        this.soapClientHandler = soapClientHandler;
    }

    @Override
    public C createAdsServiceClient(D adsServiceDescriptor, S adsSession) throws ServiceException {
        Object soapClient = this.createSoapClient(adsServiceDescriptor);
        C adsServiceClient = this.createServiceClient(soapClient, adsServiceDescriptor, adsSession);
        try {
            ((SoapServiceClient)adsServiceClient).setEndpointAddress(adsServiceDescriptor.getEndpointAddress(adsSession.getEndpoint()));
        }
        catch (MalformedURLException e) {
            throw new ServiceException("Unexpected exception", e);
        }
        return adsServiceClient;
    }

    @VisibleForTesting
    C createServiceClient(Object soapClient, D adsServiceDescriptor, S adsSession) {
        return this.adsServiceClientFactory.create(soapClient, adsServiceDescriptor, adsSession);
    }

    @Override
    public D createServiceDescriptor(Class<?> interfaceClass, String version) {
        return this.adsServiceDescriptorFactory.create(interfaceClass, version);
    }

    @VisibleForTesting
    Object createSoapClient(D adsServiceDescriptor) {
        return this.soapClientHandler.createSoapClient((SoapServiceDescriptor)adsServiceDescriptor);
    }

    @Override
    public void checkServiceClientPreconditions(S adsSession, Class<?> interfaceClass) throws ServiceException {
    }
}

