/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils;

import com.google.api.ads.adwords.lib.utils.AdHocReportDownloadHelper;
import com.google.api.ads.adwords.lib.utils.RawReportDownloadResponse;
import com.google.api.ads.adwords.lib.utils.ReportDownloadResponse;
import com.google.api.ads.adwords.lib.utils.ReportException;
import com.google.api.ads.common.lib.utils.Streams;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyErrorResponseHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)(String.valueOf(AdHocReportDownloadHelper.class.getPackage().getName()) + ".report_download"));
    private static final String ERROR_MESSAGE_REGEX = "^.*!!![^|]*\\|\\|\\|([^|]*)\\|\\|\\|([^?]*)\\?\\?\\?.*$";
    private static final int ERROR_MESSAGE_GROUP = 2;

    public ReportDownloadResponse handleResponse(RawReportDownloadResponse response) throws ReportException {
        if (response.getHttpStatus() == 200) {
            return new ReportDownloadResponse(response.getHttpStatus(), "SUCCESS", response.getInputStream());
        }
        try {
            String responseMessage = Streams.readAll(response.getInputStream());
            Matcher matcher = Pattern.compile(ERROR_MESSAGE_REGEX).matcher(responseMessage);
            if (matcher.matches()) {
                responseMessage = matcher.group(2);
            }
            logger.warn(responseMessage);
            return new ReportDownloadResponse(response.getHttpStatus(), responseMessage, null);
        }
        catch (IOException e) {
            throw new ReportException("Problem sending data to report download server.", e);
        }
    }
}

