/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils;

import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.utils.AwqlReportBodyProvider;
import com.google.api.ads.adwords.lib.utils.RawReportDownloadResponse;
import com.google.api.ads.adwords.lib.utils.ReportBodyProvider;
import com.google.api.ads.adwords.lib.utils.ReportDefinitionBodyProvider;
import com.google.api.ads.adwords.lib.utils.ReportException;
import com.google.api.ads.adwords.lib.utils.ReportRequestFactoryHelper;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.MalformedURLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdHocReportDownloadHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)(String.valueOf(AdHocReportDownloadHelper.class.getPackage().getName()) + ".report_download"));
    private final AdWordsSession session;
    private final ReportRequestFactoryHelper reportUrlConnectionHelper;
    private final String version;

    public AdHocReportDownloadHelper(AdWordsSession session, String version) {
        this.session = session;
        this.version = version;
        this.reportUrlConnectionHelper = new ReportRequestFactoryHelper(session);
    }

    public RawReportDownloadResponse downloadReport(String reportDefinitionXml) throws ReportException {
        return this.downloadReport(new ReportDefinitionBodyProvider(reportDefinitionXml));
    }

    public RawReportDownloadResponse downloadReport(String reportQuery, String format) throws ReportException {
        return this.downloadReport(new AwqlReportBodyProvider(reportQuery, format));
    }

    protected RawReportDownloadResponse downloadReport(ReportBodyProvider reportBodyProvider) throws ReportException {
        try {
            String downloadUrl = this.generateReportUrl(this.version);
            HttpRequestFactory requestFactory = this.reportUrlConnectionHelper.getHttpRequestFactory(downloadUrl);
            HttpRequest httpRequest = requestFactory.buildPostRequest(new GenericUrl(downloadUrl), reportBodyProvider.getHttpContent());
            HttpResponse response = httpRequest.execute();
            return new RawReportDownloadResponse(response.getStatusCode(), response.getContent());
        }
        catch (MalformedURLException e) {
            throw new ReportException("Created invalid report download URL.", e);
        }
        catch (IOException e) {
            throw new ReportException("Problem sending data to report download server.", e);
        }
        catch (AuthenticationException e) {
            throw new ReportException("Problem with OAuth authorization.", e);
        }
    }

    @VisibleForTesting
    String generateReportUrl(String version) {
        return String.valueOf(this.session.getEndpoint()) + "/api/adwords/reportdownload" + '/' + version;
    }
}

