/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfa.lib.auth;

import com.google.api.ads.dfa.lib.client.DfaSession;
import com.google.api.ads.dfa.lib.factory.DfaServiceClientFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoginTokensHelper {
    private final DfaServiceClientFactory dfaServiceClientFactory;

    @Inject
    public LoginTokensHelper(DfaServiceClientFactory dfaServiceClientFactory) {
        this.dfaServiceClientFactory = dfaServiceClientFactory;
    }

    @VisibleForTesting
    public Class getLoginClass(String stubPackage) throws ClassNotFoundException {
        return Class.forName(String.valueOf(stubPackage) + ".LoginRemote");
    }

    @VisibleForTesting
    Class getUserProfileClass(String stubPackage) throws ClassNotFoundException {
        return Class.forName(String.valueOf(stubPackage) + ".UserProfile");
    }

    @VisibleForTesting
    Object getLoginService(DfaSession session, Class<?> loginClass) {
        return this.dfaServiceClientFactory.getServiceClientAsInterface(session, loginClass);
    }

    @VisibleForTesting
    Object authenticate(String username, String password, Class<?> loginClass, Object loginService) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class[] paramTypes = new Class[]{String.class, String.class};
        Method authMethod = loginClass.getDeclaredMethod("authenticate", paramTypes);
        Object[] argList = new Object[]{username, password};
        return authMethod.invoke(loginService, argList);
    }

    @VisibleForTesting
    String retrieveToken(Object userProfile) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Class[] paramTypes = new Class[]{};
        Object[] argList = new Object[]{};
        Method getToken = userProfile.getClass().getMethod("getToken", paramTypes);
        return (String)getToken.invoke(userProfile, argList);
    }

    @VisibleForTesting
    Object impersonateNetwork(String username, String token, Long networkToImpersonate, Class<?> loginClass, Object loginService) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class[] paramTypes = new Class[]{String.class, String.class, Long.TYPE};
        Method authMethod = loginClass.getDeclaredMethod("impersonateNetwork", paramTypes);
        Object[] argList = new Object[]{username, token, networkToImpersonate};
        return authMethod.invoke(loginService, argList);
    }

    @VisibleForTesting
    Object impersonateUser(String username, String token, String usernameToImpersonate, Class<?> loginClass, Object loginService) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class[] paramTypes = new Class[]{String.class, String.class, String.class};
        Method authMethod = loginClass.getDeclaredMethod("impersonateUser", paramTypes);
        Object[] argList = new Object[]{username, token, usernameToImpersonate};
        return authMethod.invoke(loginService, argList);
    }
}

