/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Maps {
    private Maps() {
    }

    public static <K, V, T> Map<K, V> toMap(List<T> entryList) throws IllegalArgumentException {
        Preconditions.checkNotNull(entryList, (Object)"Entry list cannot be null.");
        Map result = com.google.common.collect.Maps.newHashMap();
        for (T entry : entryList) {
            try {
                Object key = PropertyUtils.getProperty(entry, (String)"key");
                Object value = PropertyUtils.getProperty(entry, (String)"value");
                result.put(key, value);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("Unexpected exception while creating map: " + e.getMessage(), e.getTargetException());
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Unexpected exception while creating map: " + e.getMessage(), e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Unexpected exception while creating map: " + e.getMessage(), e);
            }
        }
        return result;
    }

    public static <K, V, T> Map<K, V> toMap(T[] entryArray) throws IllegalArgumentException {
        if (entryArray == null) {
            return com.google.common.collect.Maps.newHashMap();
        }
        return Maps.toMap(Arrays.asList(entryArray));
    }

    public static <K, V, T> T[] toArray(Map<K, V> map, T[] entryArray) {
        return Maps.toList(map, entryArray.getClass().getComponentType()).toArray(entryArray);
    }

    public static <K, V, T> List<T> toList(Map<K, V> map, Class<T> entryClass) {
        Preconditions.checkNotNull(entryClass, (Object)"Entry class cannot be null.");
        List result = Lists.newArrayList();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            try {
                T newEntry = entryClass.newInstance();
                PropertyUtils.setProperty(newEntry, (String)"key", entry.getKey());
                PropertyUtils.setProperty(newEntry, (String)"value", entry.getValue());
                result.add(newEntry);
            }
            catch (InvocationTargetException e) {
                new IllegalStateException("Unexpected exception while creating map entries: " + e.getMessage(), e.getTargetException());
            }
            catch (IllegalAccessException e) {
                new IllegalStateException("Unexpected exception while creating map entries: " + e.getMessage(), e);
            }
            catch (InstantiationException e) {
                new IllegalStateException("Unexpected exception while creating map entries: " + e.getMessage(), e);
            }
            catch (NoSuchMethodException e) {
                new IllegalStateException("Unexpected exception while creating map entries: " + e.getMessage(), e);
            }
        }
        return result;
    }
}

