/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.client;

import com.google.api.ads.adwords.lib.conf.AdWordsApiConfiguration;
import com.google.api.ads.common.lib.client.AdsServiceDescriptor;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.compatability.Axis2Compatible;
import com.google.api.ads.common.lib.soap.compatability.AxisCompatible;
import com.google.api.ads.common.lib.soap.compatability.JaxWsCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.net.MalformedURLException;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdWordsServiceDescriptor
implements AdsServiceDescriptor,
AxisCompatible,
Axis2Compatible,
JaxWsCompatible {
    private final Class<?> interfaceClass;
    private final String version;
    private final AdWordsApiConfiguration apiConfig;

    @Inject
    public AdWordsServiceDescriptor(@Assisted(value="interfaceClass") Class<?> interfaceClass, @Assisted(value="version") String version, AdWordsApiConfiguration apiConfig) {
        this.interfaceClass = interfaceClass;
        this.version = version;
        this.apiConfig = apiConfig;
    }

    @Override
    public Class<?> getInterfaceClass() throws ServiceException {
        return this.interfaceClass;
    }

    @Override
    public String getEndpointAddress(String endpointServer) throws MalformedURLException {
        String serviceName = this.getServiceName();
        String endpointServerUrl = new URL(endpointServer).toString();
        if (endpointServerUrl.endsWith("/")) {
            endpointServerUrl = endpointServerUrl.substring(0, endpointServerUrl.length() - 1);
        }
        return String.valueOf(endpointServerUrl) + "/api/adwords/" + this.apiConfig.getServiceUrlGroup(this.version, serviceName) + "/" + this.version + "/" + serviceName;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Class<?> getStubClass() throws ClassNotFoundException {
        return Class.forName(String.valueOf(this.interfaceClass.getPackage().getName()) + "." + this.getServiceName() + "Stub");
    }

    @Override
    public Class<?> getLocatorClass() throws ClassNotFoundException {
        return Class.forName(String.valueOf(this.interfaceClass.getPackage().getName()) + "." + this.getServiceName() + "Locator");
    }

    @Override
    public Class<?> getServiceClass() throws ClassNotFoundException {
        return Class.forName(String.valueOf(this.interfaceClass.getPackage().getName()) + "." + this.getServiceName());
    }

    @VisibleForTesting
    String getServiceName() {
        String simpleName = this.interfaceClass.getSimpleName();
        return simpleName.substring(0, simpleName.indexOf("Interface"));
    }

    @VisibleForTesting
    String getPackageGroup() {
        String packageName = this.interfaceClass.getPackage().getName();
        String[] parts = packageName.split("\\.");
        return parts[parts.length - 1];
    }
}

