/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfp.lib.client;

import com.google.api.ads.common.lib.auth.OAuthCompatible;
import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.client.Endpoint;
import com.google.api.ads.common.lib.conf.ConfigurationHelper;
import com.google.api.ads.common.lib.exception.ValidationException;
import com.google.api.client.auth.oauth.OAuthParameters;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.configuration.Configuration;

public class DfpSession
implements AdsSession,
OAuthCompatible {
    private String endpoint;
    private String clientLoginToken;
    private String applicationName;
    private String networkCode;
    private OAuthParameters oAuthParameters;

    private DfpSession() {
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public OAuthParameters getOAuthParameters() {
        return this.oAuthParameters;
    }

    public String getClientLoginToken() {
        return this.clientLoginToken;
    }

    public void setClientLoginToken(String clientLoginToken) {
        this.clientLoginToken = clientLoginToken;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public boolean isEnvironment(Endpoint environment) {
        return environment.getEndpoint().equals(this.endpoint);
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public void setNetworkCode(String networkCode) {
        this.networkCode = networkCode;
    }

    /* synthetic */ DfpSession(DfpSession dfpSession) {
        this();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements com.google.api.ads.common.lib.utils.Builder<DfpSession> {
        private DfpSession dfpSession = new DfpSession(null);
        private String environmentString;
        @VisibleForTesting
        ConfigurationHelper configHelper;

        public Builder() {
            this.configHelper = new ConfigurationHelper();
        }

        @VisibleForTesting
        Builder(ConfigurationHelper configHelper) {
            this.configHelper = configHelper;
        }

        public Builder fromFile() {
            return this.fromFile("ads.properties");
        }

        public Builder fromFile(String path) {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder fromFile(File path) {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder fromFile(URL path) {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder from(Configuration config) {
            this.dfpSession.clientLoginToken = config.getString("api.dfp.clientLoginToken", null);
            this.dfpSession.applicationName = config.getString("api.dfp.applicationName", null);
            this.dfpSession.networkCode = config.getString("api.dfp.networkCode", null);
            this.dfpSession.endpoint = config.getString("api.dfp.endpoint", null);
            this.environmentString = config.getString("api.dfp.environment", null);
            return this;
        }

        public Builder withClientLoginToken(String clientLoginToken) {
            this.dfpSession.clientLoginToken = clientLoginToken;
            return this;
        }

        public Builder withOAuthParameters(OAuthParameters oAuthParameters) {
            this.dfpSession.oAuthParameters = oAuthParameters;
            return this;
        }

        public Builder withNetworkCode(String networkCode) {
            this.dfpSession.networkCode = networkCode;
            return this;
        }

        public Builder withApplicationName(String applicationName) {
            this.dfpSession.applicationName = applicationName;
            return this;
        }

        public Builder withEnvironment(Environment environment) {
            this.dfpSession.endpoint = environment.getEndpoint();
            return this;
        }

        public Builder withEndpoint(String endpoint) {
            this.dfpSession.endpoint = endpoint;
            return this;
        }

        @Override
        public DfpSession build() throws ValidationException {
            this.validate(this.dfpSession);
            return this.dfpSession;
        }

        private void validate(DfpSession dfpSession) throws ValidationException {
            boolean usingClientLogin;
            if (this.environmentString != null) {
                try {
                    this.withEnvironment(Environment.valueOf(this.environmentString.toUpperCase()));
                }
                catch (IllegalArgumentException e) {
                    throw new ValidationException(String.format("Environment [%s] not recognized.", this.environmentString), "api.dfp.environment", e);
                }
            }
            boolean bl = usingClientLogin = dfpSession.getClientLoginToken() != null;
            if (usingClientLogin && dfpSession.getOAuthParameters() != null) {
                throw new ValidationException("Both ClientLogin authetication (clientLoginToken) and OAuth authentication cannot be used at the same time.", "");
            }
            if (!usingClientLogin && dfpSession.getOAuthParameters() == null) {
                throw new ValidationException("Either ClientLogin authetication (email/password or clientLoginToken) or OAuth authentication must be used.", "");
            }
            try {
                new URL(dfpSession.getEndpoint());
            }
            catch (MalformedURLException e) {
                throw new ValidationException("Endpoint is required and must be a valid URL.", "endpoint", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Environment implements Endpoint
    {
        PRODUCTION("https://www.google.com/"),
        SANDBOX("https://sandbox.google.com/");

        private final String endpoint;

        private Environment(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public String getEndpoint() {
            return this.endpoint;
        }
    }
}

