/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfa.lib.auth;

import com.google.api.ads.dfa.lib.auth.LoginTokenException;
import com.google.api.ads.dfa.lib.auth.LoginTokensHelper;
import com.google.api.ads.dfa.lib.client.DfaSession;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;

public class LoginTokens {
    private final LoginTokensHelper loginTokensHelper;

    @Inject
    public LoginTokens(LoginTokensHelper loginTokensHelper) {
        this.loginTokensHelper = loginTokensHelper;
    }

    public String generateToken(String stubPackage, DfaSession session) throws LoginTokenException {
        try {
            Class loginClass = this.loginTokensHelper.getLoginClass(stubPackage);
            Object loginService = this.loginTokensHelper.getLoginService(session, loginClass);
            Object userProfile = this.loginTokensHelper.authenticate(session.getUsername(), session.getPassword(), loginClass, loginService);
            return this.loginTokensHelper.retrieveToken(userProfile);
        }
        catch (ClassNotFoundException e) {
            throw new LoginTokenException("Unable to generate authentication token because of error:", e);
        }
        catch (NoSuchMethodException e) {
            throw new LoginTokenException("Unable to generate authentication token because of error:", e);
        }
        catch (InvocationTargetException e) {
            throw new LoginTokenException("Unable to generate authentication token because of error:", e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new LoginTokenException("Unable to generate authentication token because of error:", e);
        }
    }

    public String generateImpersonateNetworkToken(String stubPackage, DfaSession session) throws LoginTokenException {
        try {
            Class loginClass = this.loginTokensHelper.getLoginClass(stubPackage);
            Object loginService = this.loginTokensHelper.getLoginService(session, loginClass);
            Object userProfile = this.loginTokensHelper.impersonateNetwork(session.getUsername(), session.getToken(), session.getNetworkToImpersonate(), loginClass, loginService);
            return this.loginTokensHelper.retrieveToken(userProfile);
        }
        catch (ClassNotFoundException e) {
            throw new LoginTokenException("Unable to generate authentication token because of error:", e);
        }
        catch (NoSuchMethodException e) {
            throw new LoginTokenException("Unable to generate authentication token because of error:", e);
        }
        catch (InvocationTargetException e) {
            throw new LoginTokenException("Unable to generate authentication token because of error:", e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new LoginTokenException("Unable to generate authentication token because of error:", e);
        }
    }

    public String generateImpersonateUserToken(String stubPackage, DfaSession session) throws LoginTokenException {
        try {
            Class loginClass = this.loginTokensHelper.getLoginClass(stubPackage);
            Object loginService = this.loginTokensHelper.getLoginService(session, loginClass);
            Object userProfile = this.loginTokensHelper.impersonateUser(session.getUsername(), session.getToken(), session.getUsernameToImpersonate(), loginClass, loginService);
            return this.loginTokensHelper.retrieveToken(userProfile);
        }
        catch (ClassNotFoundException e) {
            throw new LoginTokenException("Unable to generate authentication token because of error:", e);
        }
        catch (NoSuchMethodException e) {
            throw new LoginTokenException("Unable to generate authentication token because of error:", e);
        }
        catch (InvocationTargetException e) {
            throw new LoginTokenException("Unable to generate authentication token because of error:", e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new LoginTokenException("Unable to generate authentication token because of error:", e);
        }
    }
}

