/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.client;

import com.google.api.ads.common.lib.auth.OAuthCompatible;
import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.client.Endpoint;
import com.google.api.ads.common.lib.conf.ConfigurationHelper;
import com.google.api.ads.common.lib.exception.ValidationException;
import com.google.api.client.auth.oauth.OAuthParameters;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.configuration.Configuration;

public class AdWordsSession
implements AdsSession,
OAuthCompatible {
    private String endpoint;
    private String clientLoginToken;
    private String userAgent;
    private String developerToken;
    private String clientCustomerId;
    private OAuthParameters oAuthParameters;
    private Boolean isPartialFailure;
    private Boolean isValidateOnly;
    private Boolean isReportMoneyInMicros = Boolean.FALSE;

    private AdWordsSession() {
    }

    public String getClientCustomerId() {
        return this.clientCustomerId;
    }

    public void setClientCustomerId(String clientCustomerId) {
        this.clientCustomerId = clientCustomerId;
    }

    public Boolean isValidateOnly() {
        return this.isValidateOnly;
    }

    public void setValidateOnly(Boolean isValidateOnly) {
        this.isValidateOnly = isValidateOnly;
    }

    public void setPartialFailure(Boolean isPartialFailure) {
        this.isPartialFailure = isPartialFailure;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getDeveloperToken() {
        return this.developerToken;
    }

    public Boolean isPartialFailure() {
        return this.isPartialFailure;
    }

    public OAuthParameters getOAuthParameters() {
        return this.oAuthParameters;
    }

    public String getClientLoginToken() {
        return this.clientLoginToken;
    }

    public void setClientLoginToken(String clientLoginToken) {
        this.clientLoginToken = clientLoginToken;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setReportMoneyInMicros(Boolean reportMoneyInMicros) {
        this.isReportMoneyInMicros = reportMoneyInMicros;
    }

    public Boolean isReportMoneyInMicros() {
        return this.isReportMoneyInMicros;
    }

    public boolean isEnvironment(Endpoint environment) {
        return environment.getEndpoint().equals(this.endpoint);
    }

    /* synthetic */ AdWordsSession(AdWordsSession adWordsSession) {
        this();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements com.google.api.ads.common.lib.utils.Builder<AdWordsSession> {
        private AdWordsSession adWordsSession = new AdWordsSession(null);
        private String environmentString;
        @VisibleForTesting
        ConfigurationHelper configHelper;

        public Builder() {
            this.configHelper = new ConfigurationHelper();
        }

        @VisibleForTesting
        Builder(ConfigurationHelper configHelper) {
            this.configHelper = configHelper;
        }

        public Builder fromFile() {
            return this.fromFile("ads.properties");
        }

        public Builder fromFile(String path) {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder fromFile(File path) {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder fromFile(URL path) {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder from(Configuration config) {
            this.adWordsSession.clientLoginToken = config.getString("api.adwords.clientLoginToken", null);
            this.adWordsSession.clientCustomerId = config.getString("api.adwords.clientCustomerId", null);
            this.adWordsSession.userAgent = config.getString("api.adwords.userAgent", null);
            this.adWordsSession.developerToken = config.getString("api.adwords.developerToken", null);
            this.adWordsSession.isPartialFailure = config.getBoolean("api.adwords.isPartialFailure", null);
            this.adWordsSession.endpoint = config.getString("api.adwords.endpoint", null);
            this.adWordsSession.isReportMoneyInMicros = config.getBoolean("api.adwords.reportMoneyInMicros", Boolean.FALSE);
            this.environmentString = config.getString("api.adwords.environment", null);
            return this;
        }

        public Builder withClientLoginToken(String clientLoginToken) {
            this.adWordsSession.clientLoginToken = clientLoginToken;
            return this;
        }

        public Builder withDeveloperToken(String developerToken) {
            this.adWordsSession.developerToken = developerToken;
            return this;
        }

        public Builder withOAuthParameters(OAuthParameters oAuthParameters) {
            this.adWordsSession.oAuthParameters = oAuthParameters;
            return this;
        }

        public Builder withUserAgent(String userAgent) {
            this.adWordsSession.userAgent = userAgent;
            return this;
        }

        public Builder withEnvironment(Environment environment) {
            this.adWordsSession.endpoint = environment.getEndpoint();
            return this;
        }

        public Builder withEndpoint(String endpoint) {
            this.adWordsSession.endpoint = endpoint;
            return this;
        }

        public Builder withClientCustomerId(String clientCustomerId) {
            this.adWordsSession.clientCustomerId = clientCustomerId;
            return this;
        }

        public Builder enablePartialFailure() {
            this.adWordsSession.isPartialFailure = true;
            return this;
        }

        public Builder enableReportMoneyInMicros() {
            this.adWordsSession.isReportMoneyInMicros = true;
            return this;
        }

        @Override
        public AdWordsSession build() throws ValidationException {
            this.validate(this.adWordsSession);
            return this.adWordsSession;
        }

        private void validate(AdWordsSession adWordsSession) throws ValidationException {
            boolean usingClientLogin;
            if (this.environmentString != null) {
                try {
                    this.withEnvironment(Environment.valueOf(this.environmentString.toUpperCase()));
                }
                catch (IllegalArgumentException e) {
                    throw new ValidationException(String.format("Environment [%s] not recognized.", this.environmentString), "api.adwords.environment", e);
                }
            }
            boolean bl = usingClientLogin = adWordsSession.getClientLoginToken() != null;
            if (usingClientLogin && adWordsSession.getOAuthParameters() != null) {
                throw new ValidationException("Both ClientLogin authetication (clientLoginToken) and OAuth authentication cannot be used at the same time.", "");
            }
            if (!usingClientLogin && adWordsSession.getOAuthParameters() == null) {
                throw new ValidationException("Either ClientLogin authetication (email/password or clientLoginToken) or OAuth authentication must be used.", "");
            }
            if (adWordsSession.getDeveloperToken() == null) {
                throw new ValidationException("A developer token must be set.", "developerToken");
            }
            try {
                new URL(adWordsSession.getEndpoint());
            }
            catch (MalformedURLException e) {
                throw new ValidationException("Endpoint is required and must be a valid URL.", "endpoint", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Environment implements Endpoint
    {
        PRODUCTION("https://adwords.google.com/"),
        SANDBOX("https://adwords-sandbox.google.com/");

        private final String endpoint;

        private Environment(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public String getEndpoint() {
            return this.endpoint;
        }
    }
}

