/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.conf;

import com.google.api.ads.common.lib.utils.logging.AdsServiceLoggers;
import com.google.common.base.Throwables;
import java.io.File;
import java.net.URL;
import java.security.AccessControlException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class ConfigurationHelper {
    public Configuration fromFile(String path) {
        PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration();
        try {
            propertiesConfiguration.load(path);
        }
        catch (ConfigurationException e) {
            if (Throwables.getRootCause((Throwable)e) instanceof AccessControlException) {
                AdsServiceLoggers.ADS_API_LIB_LOG.debug("Module could not be loaded.", (Throwable)e);
            }
            throw new IllegalArgumentException("Encountered a problem reading the provided configuration file \"" + path + "\"!", e);
        }
        return propertiesConfiguration;
    }

    public Configuration fromFile(File path) {
        try {
            return new PropertiesConfiguration(path);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Encountered a problem reading the provided configuration file \"" + path + "\"!", e);
        }
    }

    public Configuration fromFile(URL path) {
        try {
            return new PropertiesConfiguration(path);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Encountered a problem reading the provided configuration file \"" + path + "\"!", e);
        }
    }
}

