/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.soap.axis.conf;

import com.google.api.ads.common.lib.conf.AdsLibConfiguration;
import com.google.inject.Inject;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.EngineConfigurationFactory;
import org.apache.axis.configuration.EngineConfigurationFactoryDefault;
import org.apache.axis.configuration.FileProvider;

public class AdsAxisEngineConfigurationFactory
implements EngineConfigurationFactory {
    private final AdsLibConfiguration adsLibConfiguration;
    private final EngineConfigurationFactory wrappedFactory;

    @Inject
    public AdsAxisEngineConfigurationFactory(AdsLibConfiguration adsLibConfiguration) {
        this.adsLibConfiguration = adsLibConfiguration;
        this.wrappedFactory = EngineConfigurationFactoryDefault.newFactory(null);
    }

    public EngineConfiguration getClientEngineConfig() {
        if (System.getProperty("axis.ClientConfigFile") == null && this.adsLibConfiguration.isCompressionEnabled()) {
            return new FileProvider(this.getClass().getResourceAsStream("wsdd/ads-axis-client-config.wsdd"));
        }
        return this.wrappedFactory.getClientEngineConfig();
    }

    public EngineConfiguration getServerEngineConfig() {
        return this.wrappedFactory.getServerEngineConfig();
    }
}

