/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.soap.axis;

import com.google.api.ads.common.lib.conf.ConfigurationHelper;
import com.google.api.ads.common.lib.conf.ConfigurationLoadException;
import com.google.api.ads.common.lib.soap.SoapClientHandlerInterface;
import com.google.api.ads.common.lib.soap.axis.AxisFrameworkUserAgentProvider;
import com.google.api.ads.common.lib.soap.axis.AxisHandler;
import com.google.api.ads.common.lib.soap.axis.conf.AdsAxisEngineConfigurationFactory;
import com.google.api.ads.common.lib.useragent.FrameworkUserAgentProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.apache.axis.EngineConfigurationFactory;
import org.apache.axis.Version;
import org.apache.commons.configuration.Configuration;

public class AxisModule
extends AbstractModule {
    private final ConfigurationHelper configurationHelper;

    public AxisModule() {
        this(new ConfigurationHelper());
    }

    @VisibleForTesting
    AxisModule(ConfigurationHelper configurationHelper) {
        this.configurationHelper = configurationHelper;
    }

    protected void configure() {
        this.bind(EngineConfigurationFactory.class).to(AdsAxisEngineConfigurationFactory.class);
        this.bind((TypeLiteral)new TypeLiteral<SoapClientHandlerInterface>(){}).to(AxisHandler.class).asEagerSingleton();
        this.bind(FrameworkUserAgentProvider.class).to(AxisFrameworkUserAgentProvider.class);
        try {
            this.bind(Configuration.class).annotatedWith((Annotation)Names.named((String)"axisResources")).toInstance((Object)this.configurationHelper.fromFile(Version.class.getResource("/org/apache/axis/i18n/resource.properties")));
        }
        catch (ConfigurationLoadException e) {
            throw new IllegalStateException("Could not not Axis resource properties.", e);
        }
    }
}

