/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.soap.jaxws;

import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class JaxWsSoapContextHandler
implements SOAPHandler<SOAPMessageContext> {
    private String lastSoapRequest;
    private String lastSoapResponse;
    private String lastServiceCalled;
    private String lastOperationCalled;
    private Set<SOAPElement> soapHeaders = new HashSet<SOAPElement>();

    public boolean handleMessage(SOAPMessageContext context) {
        if (((Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound")).booleanValue()) {
            SOAPMessage soapMessage = context.getMessage();
            try {
                SOAPHeader soapHeader = soapMessage.getSOAPHeader();
                if (soapHeader == null) {
                    soapHeader = soapMessage.getSOAPPart().getEnvelope().addHeader();
                }
                for (SOAPElement header : this.soapHeaders) {
                    soapHeader.addChildElement(header);
                }
            }
            catch (SOAPException e) {
                throw new ServiceException("Error setting SOAP headers on outbound message.", (Throwable)e);
            }
            this.captureServiceAndOperationNames(context);
        }
        this.captureSoapXml(context);
        return true;
    }

    @VisibleForTesting
    void captureServiceAndOperationNames(SOAPMessageContext context) {
        this.lastServiceCalled = ((QName)context.get((Object)"javax.xml.ws.wsdl.service")).getLocalPart();
        try {
            this.lastOperationCalled = context.getMessage().getSOAPBody().getFirstChild().getLocalName();
        }
        catch (SOAPException sOAPException) {
            this.lastOperationCalled = "";
        }
    }

    public String getLastOperationCalled() {
        return this.lastOperationCalled;
    }

    public String getLastServiceCalled() {
        return this.lastServiceCalled;
    }

    public boolean handleFault(SOAPMessageContext context) {
        this.captureSoapXml(context);
        return true;
    }

    private void captureSoapXml(SOAPMessageContext context) {
        SOAPMessage message = context.getMessage();
        String soapXml = "";
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            message.writeTo((OutputStream)outputStream);
            soapXml = ((Object)outputStream).toString();
        }
        catch (IOException e) {
            soapXml = "Exception logging SOAP message: " + e;
        }
        catch (SOAPException e) {
            soapXml = "Exception logging SOAP message: " + (Object)((Object)e);
        }
        if (((Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound")).booleanValue()) {
            this.lastSoapRequest = soapXml;
        } else {
            this.lastSoapResponse = soapXml;
        }
    }

    public String getLastRequestXml() {
        return this.lastSoapRequest;
    }

    public String getLastResponseXml() {
        return this.lastSoapResponse;
    }

    public void addHeader(String namespace, String headerName, SOAPElement headerValue) {
        this.soapHeaders.add(headerValue);
    }

    public void clearHeaders() {
        this.soapHeaders.clear();
    }

    public Set<SOAPElement> getAddedHeaders() {
        return this.soapHeaders;
    }

    public Set<QName> getHeaders() {
        return null;
    }

    public void close(MessageContext messageContext) {
    }
}

