/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.soap.jaxws;

import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.RequestInfo;
import com.google.api.ads.common.lib.soap.ResponseInfo;
import com.google.api.ads.common.lib.soap.SoapCall;
import com.google.api.ads.common.lib.soap.SoapCallReturn;
import com.google.api.ads.common.lib.soap.SoapClientHandler;
import com.google.api.ads.common.lib.soap.SoapServiceDescriptor;
import com.google.api.ads.common.lib.soap.compatability.JaxWsCompatible;
import com.google.api.ads.common.lib.soap.jaxws.JaxWsSoapContextHandler;
import com.google.api.ads.common.lib.soap.jaxws.JaxWsSoapContextHandlerFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsHandler
extends SoapClientHandler<BindingProvider> {
    private static final int REQUEST_TIMEOUT = 600000;
    private static final String PRODUCTION_REQUEST_TIMEOUT_KEY = "com.sun.xml.ws.request.timeout";
    private static final String PRODUCTION_CONNECT_TIMEOUT_KEY = "com.sun.xml.ws.connect.timeout";
    private static final String DEVEL_REQUEST_TIMEOUT_KEY = "com.sun.xml.internal.ws.request.timeout";
    private static final String DEVEL_CONNECT_TIMEOUT_KEY = "com.sun.xml.internal.ws.connect.timeout";
    private JaxWsSoapContextHandlerFactory contextHandlerFactory;

    @Inject
    protected JaxWsHandler(JaxWsSoapContextHandlerFactory contextHandlerFactory) {
        this.contextHandlerFactory = contextHandlerFactory;
    }

    public void setEndpointAddress(BindingProvider soapClient, String endpointAddress) {
        soapClient.getRequestContext().put("javax.xml.ws.service.endpoint.address", endpointAddress);
    }

    public Object getHeader(BindingProvider soapClient, String headerName) {
        for (SOAPElement addedHeader : this.getContextHandlerFromClient(soapClient).getAddedHeaders()) {
            if (!addedHeader.getNodeName().equals(headerName)) continue;
            return addedHeader;
        }
        return null;
    }

    public void clearHeaders(BindingProvider soapClient) {
        this.getContextHandlerFromClient(soapClient).clearHeaders();
        soapClient.getRequestContext().put("javax.xml.ws.http.request.headers", new HashMap());
    }

    public void setHeader(BindingProvider soapClient, String namespace, String headerName, Object headerValue) {
        if (!(headerValue instanceof SOAPElement)) {
            throw new ServiceException("Unexpected SOAP header given for JAX-WS binding. Given object of class \"" + headerValue.getClass().toString() + "\" but expecting " + "object of class \"" + SOAPElement.class + "\".", null);
        }
        this.getContextHandlerFromClient(soapClient).addHeader(namespace, headerName, (SOAPElement)headerValue);
    }

    public void setHeaderChildString(BindingProvider soapClient, String headerName, String childNamespace, String childName, String childValue) {
        SOAPElement parentHeader = (SOAPElement)this.getHeader(soapClient, headerName);
        Preconditions.checkNotNull((Object)parentHeader, (String)"No header element found with name: %s", (Object[])new Object[]{headerName});
        try {
            SOAPElement childElement = parentHeader.addChildElement(new QName(childNamespace, childName));
            childElement.setTextContent(childValue);
        }
        catch (SOAPException e) {
            throw new ServiceException("Failed to set header for child " + childName, (Throwable)e);
        }
    }

    public void putAllHttpHeaders(BindingProvider soapClient, Map<String, String> headersMap) {
        Map httpHeaders = (Map)soapClient.getRequestContext().get("javax.xml.ws.http.request.headers");
        if (httpHeaders == null) {
            httpHeaders = Maps.newHashMap();
        }
        for (String key : headersMap.keySet()) {
            httpHeaders.put(key, Lists.newArrayList((Object[])new String[]{headersMap.get(key)}));
        }
        soapClient.getRequestContext().put("javax.xml.ws.http.request.headers", httpHeaders);
    }

    public void setCompression(BindingProvider soapClient, boolean compress) {
        HashMap headersMap = Maps.newHashMap();
        if (compress) {
            headersMap.put("Accept-Encoding", "gzip");
            headersMap.put("Content-Encoding", "gzip");
            this.putAllHttpHeaders(soapClient, (Map<String, String>)headersMap);
        } else {
            Map httpHeaders = (Map)soapClient.getRequestContext().get("javax.xml.ws.http.request.headers");
            if (httpHeaders != null) {
                httpHeaders.remove("Accept-Encoding");
                httpHeaders.remove("Content-Encoding");
            }
        }
    }

    public BindingProvider createSoapClient(SoapServiceDescriptor soapServiceDescriptor) throws ServiceException {
        try {
            if (soapServiceDescriptor instanceof JaxWsCompatible) {
                JaxWsCompatible jaxWsCompatibleService = (JaxWsCompatible)soapServiceDescriptor;
                Object portLocator = jaxWsCompatibleService.getServiceClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                String interfaceClassName = soapServiceDescriptor.getInterfaceClass().getSimpleName();
                BindingProvider soapClient = (BindingProvider)portLocator.getClass().getMethod("get" + interfaceClassName + "Port", new Class[0]).invoke(portLocator, new Object[0]);
                this.setTimeOut(soapClient);
                List bindings = soapClient.getBinding().getHandlerChain();
                bindings.add(this.contextHandlerFactory.getJaxWsSoapContextHandler());
                soapClient.getBinding().setHandlerChain(bindings);
                return soapClient;
            }
            throw new ServiceException("Service [" + soapServiceDescriptor + "] is not compatible with JAX-WS", null);
        }
        catch (SecurityException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException("Unexpected Exception.", e.getCause());
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
    }

    private void setTimeOut(BindingProvider bindingProvider) {
        bindingProvider.getRequestContext().put(PRODUCTION_REQUEST_TIMEOUT_KEY, 600000);
        bindingProvider.getRequestContext().put(PRODUCTION_CONNECT_TIMEOUT_KEY, 600000);
        bindingProvider.getRequestContext().put(DEVEL_REQUEST_TIMEOUT_KEY, 600000);
        bindingProvider.getRequestContext().put(DEVEL_CONNECT_TIMEOUT_KEY, 600000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoapCallReturn invokeSoapCall(SoapCall<BindingProvider> soapCall) {
        BindingProvider webService = (BindingProvider)soapCall.getSoapClient();
        SoapCallReturn.Builder builder = new SoapCallReturn.Builder();
        BindingProvider bindingProvider = webService;
        synchronized (bindingProvider) {
            Object result;
            block10: {
                result = null;
                try {
                    result = this.invoke(soapCall);
                }
                catch (InvocationTargetException e) {
                    builder.withException(e.getTargetException());
                    JaxWsSoapContextHandler contextHandler = this.getContextHandlerFromClient(webService);
                    builder.withRequestInfo(new RequestInfo.Builder().withSoapRequestXml(contextHandler.getLastRequestXml()).withMethodName(contextHandler.getLastOperationCalled()).withServiceName(contextHandler.getLastServiceCalled()).withUrl((String)webService.getRequestContext().get("javax.xml.ws.service.endpoint.address")).build());
                    builder.withResponseInfo(new ResponseInfo.Builder().withSoapResponseXml(contextHandler.getLastResponseXml()).build());
                    break block10;
                }
                catch (Exception e) {
                    try {
                        builder.withException((Throwable)e);
                        break block10;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        JaxWsSoapContextHandler contextHandler = this.getContextHandlerFromClient(webService);
                        builder.withRequestInfo(new RequestInfo.Builder().withSoapRequestXml(contextHandler.getLastRequestXml()).withMethodName(contextHandler.getLastOperationCalled()).withServiceName(contextHandler.getLastServiceCalled()).withUrl((String)webService.getRequestContext().get("javax.xml.ws.service.endpoint.address")).build());
                        builder.withResponseInfo(new ResponseInfo.Builder().withSoapResponseXml(contextHandler.getLastResponseXml()).build());
                    }
                }
                JaxWsSoapContextHandler contextHandler = this.getContextHandlerFromClient(webService);
                builder.withRequestInfo(new RequestInfo.Builder().withSoapRequestXml(contextHandler.getLastRequestXml()).withMethodName(contextHandler.getLastOperationCalled()).withServiceName(contextHandler.getLastServiceCalled()).withUrl((String)webService.getRequestContext().get("javax.xml.ws.service.endpoint.address")).build());
                builder.withResponseInfo(new ResponseInfo.Builder().withSoapResponseXml(contextHandler.getLastResponseXml()).build());
            }
            return builder.withReturnValue(result).build();
        }
    }

    public String getEndpointAddress(BindingProvider soapClient) {
        return (String)soapClient.getRequestContext().get("javax.xml.ws.service.endpoint.address");
    }

    public SOAPHeaderElement createSoapHeaderElement(QName qName) {
        throw new UnsupportedOperationException();
    }

    private JaxWsSoapContextHandler getContextHandlerFromClient(BindingProvider soapClient) {
        List handlers = soapClient.getBinding().getHandlerChain();
        for (Handler handler : handlers) {
            if (!(handler instanceof JaxWsSoapContextHandler)) continue;
            return (JaxWsSoapContextHandler)handler;
        }
        throw new IllegalStateException("The SOAP client passed into the JaxWsHandler does not have the necessary context handler on its binding chain.");
    }
}

