/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.ExportSavedReportMetadata;
import com.google.ads.admanager.v1.ExportSavedReportRequest;
import com.google.ads.admanager.v1.ExportSavedReportResponse;
import com.google.ads.admanager.v1.stub.HttpJsonReportServiceCallableFactory;
import com.google.ads.admanager.v1.stub.ReportServiceStub;
import com.google.ads.admanager.v1.stub.ReportServiceStubSettings;
import com.google.api.HttpRule;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpJsonReportServiceStub
extends ReportServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(ExportSavedReportMetadata.getDescriptor()).add(ExportSavedReportResponse.getDescriptor()).build();
    private static final ApiMethodDescriptor<ExportSavedReportRequest, Operation> exportSavedReportMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.ReportService/ExportSavedReport").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{report=networks/*/reports/*}:exportSavedReport", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "report", (Object)request.getReport());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearReport().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<ExportSavedReportRequest, Operation> exportSavedReportCallable;
    private final OperationCallable<ExportSavedReportRequest, ExportSavedReportResponse, ExportSavedReportMetadata> exportSavedReportOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonReportServiceStub create(ReportServiceStubSettings settings) throws IOException {
        return new HttpJsonReportServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonReportServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonReportServiceStub(ReportServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonReportServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonReportServiceStub(ReportServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonReportServiceStub(ReportServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonReportServiceCallableFactory());
    }

    protected HttpJsonReportServiceStub(ReportServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=networks/*/operations/reports/exports/*}").addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=networks/*/operations/reports/runs/*}").build()).build()).build());
        HttpJsonCallSettings exportSavedReportTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(exportSavedReportMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("report", String.valueOf(request.getReport()));
            return builder.build();
        }).build();
        this.exportSavedReportCallable = callableFactory.createUnaryCallable(exportSavedReportTransportSettings, settings.exportSavedReportSettings(), clientContext);
        this.exportSavedReportOperationCallable = callableFactory.createOperationCallable(exportSavedReportTransportSettings, settings.exportSavedReportOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(exportSavedReportMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ExportSavedReportRequest, Operation> exportSavedReportCallable() {
        return this.exportSavedReportCallable;
    }

    @Override
    public OperationCallable<ExportSavedReportRequest, ExportSavedReportResponse, ExportSavedReportMetadata> exportSavedReportOperationCallable() {
        return this.exportSavedReportOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

