/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.AdPartner;
import com.google.ads.admanager.v1.AdPartnerServiceClient;
import com.google.ads.admanager.v1.GetAdPartnerRequest;
import com.google.ads.admanager.v1.ListAdPartnersRequest;
import com.google.ads.admanager.v1.ListAdPartnersResponse;
import com.google.ads.admanager.v1.stub.AdPartnerServiceStub;
import com.google.ads.admanager.v1.stub.HttpJsonAdPartnerServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class AdPartnerServiceStubSettings
extends StubSettings<AdPartnerServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().build();
    private final UnaryCallSettings<GetAdPartnerRequest, AdPartner> getAdPartnerSettings;
    private final PagedCallSettings<ListAdPartnersRequest, ListAdPartnersResponse, AdPartnerServiceClient.ListAdPartnersPagedResponse> listAdPartnersSettings;
    private static final PagedListDescriptor<ListAdPartnersRequest, ListAdPartnersResponse, AdPartner> LIST_AD_PARTNERS_PAGE_STR_DESC = new PagedListDescriptor<ListAdPartnersRequest, ListAdPartnersResponse, AdPartner>(){

        public String emptyToken() {
            return "";
        }

        public ListAdPartnersRequest injectToken(ListAdPartnersRequest payload, String token) {
            return ListAdPartnersRequest.newBuilder((ListAdPartnersRequest)payload).setPageToken(token).build();
        }

        public ListAdPartnersRequest injectPageSize(ListAdPartnersRequest payload, int pageSize) {
            return ListAdPartnersRequest.newBuilder((ListAdPartnersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAdPartnersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAdPartnersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AdPartner> extractResources(ListAdPartnersResponse payload) {
            return payload.getAdPartnersList() == null ? ImmutableList.of() : payload.getAdPartnersList();
        }
    };
    private static final PagedListResponseFactory<ListAdPartnersRequest, ListAdPartnersResponse, AdPartnerServiceClient.ListAdPartnersPagedResponse> LIST_AD_PARTNERS_PAGE_STR_FACT = new PagedListResponseFactory<ListAdPartnersRequest, ListAdPartnersResponse, AdPartnerServiceClient.ListAdPartnersPagedResponse>(){

        public ApiFuture<AdPartnerServiceClient.ListAdPartnersPagedResponse> getFuturePagedResponse(UnaryCallable<ListAdPartnersRequest, ListAdPartnersResponse> callable, ListAdPartnersRequest request, ApiCallContext context, ApiFuture<ListAdPartnersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_AD_PARTNERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AdPartnerServiceClient.ListAdPartnersPagedResponse.createAsync((PageContext<ListAdPartnersRequest, ListAdPartnersResponse, AdPartner>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetAdPartnerRequest, AdPartner> getAdPartnerSettings() {
        return this.getAdPartnerSettings;
    }

    public PagedCallSettings<ListAdPartnersRequest, ListAdPartnersResponse, AdPartnerServiceClient.ListAdPartnersPagedResponse> listAdPartnersSettings() {
        return this.listAdPartnersSettings;
    }

    public AdPartnerServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAdPartnerServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AdPartnerServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AdPartnerServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AdPartnerServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getAdPartnerSettings = settingsBuilder.getAdPartnerSettings().build();
        this.listAdPartnersSettings = settingsBuilder.listAdPartnersSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AdPartnerServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetAdPartnerRequest, AdPartner> getAdPartnerSettings;
        private final PagedCallSettings.Builder<ListAdPartnersRequest, ListAdPartnersResponse, AdPartnerServiceClient.ListAdPartnersPagedResponse> listAdPartnersSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getAdPartnerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAdPartnersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_AD_PARTNERS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getAdPartnerSettings, this.listAdPartnersSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AdPartnerServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getAdPartnerSettings = settings.getAdPartnerSettings.toBuilder();
            this.listAdPartnersSettings = settings.listAdPartnersSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getAdPartnerSettings, this.listAdPartnersSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AdPartnerServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AdPartnerServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AdPartnerServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AdPartnerServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getAdPartnerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listAdPartnersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetAdPartnerRequest, AdPartner> getAdPartnerSettings() {
            return this.getAdPartnerSettings;
        }

        public PagedCallSettings.Builder<ListAdPartnersRequest, ListAdPartnersResponse, AdPartnerServiceClient.ListAdPartnersPagedResponse> listAdPartnersSettings() {
            return this.listAdPartnersSettings;
        }

        public AdPartnerServiceStubSettings build() throws IOException {
            return new AdPartnerServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

