/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tflite;

import com.google.android.gms.tflite.InterpreterFactoryImpl;
import com.google.android.gms.tflite.TensorImpl;
import com.google.android.gms.tflite.zzc;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tensorflow.lite.Delegate;
import org.tensorflow.lite.DelegateFactory;
import org.tensorflow.lite.InterpreterApi;
import org.tensorflow.lite.InterpreterFactoryApi;
import org.tensorflow.lite.RuntimeFlavor;
import org.tensorflow.lite.TensorFlowLite;
import org.tensorflow.lite.annotations.UsedByReflection;
import org.tensorflow.lite.nnapi.NnApiDelegate;

class NativeInterpreterWrapper
implements AutoCloseable {
    @UsedByReflection(value="nativeinterpreterwrapper_jni.cc")
    private long inferenceDurationNanoseconds;
    private static final RuntimeFlavor zzc = RuntimeFlavor.SYSTEM;
    long zza;
    long zzb;
    private long zzd;
    private long zze;
    private ByteBuffer zzf;
    private Map zzg;
    private Map zzh;
    private TensorImpl[] zzi;
    private TensorImpl[] zzj;
    private boolean zzk;
    private final List zzl;
    private final List zzm;

    private static native int getInputCount(long var0);

    private static native int getInputTensorIndex(long var0, int var2);

    private static native int getOutputCount(long var0);

    private static native int getOutputTensorIndex(long var0, int var2);

    private static native long allocateTensors(long var0, long var2);

    private static native long createCancellationFlag(long var0);

    private static native long createErrorReporter(int var0);

    private static native long createInterpreter(long var0, long var2, int var4, boolean var5, List<Long> var6);

    private static native long createModel(String var0, long var1);

    private static native long createModelWithBuffer(ByteBuffer var0, long var1);

    private static native long deleteCancellationFlag(long var0);

    @Override
    public final void close() {
        Object object;
        int n;
        for (n = 0; n < ((TensorImpl[])(object = this.zzi)).length; ++n) {
            if ((object = object[n]) == null) continue;
            ((TensorImpl)object).zzc();
            this.zzi[n] = null;
        }
        for (n = 0; n < ((Object)(object = this.zzj)).length; ++n) {
            if ((object = object[n]) == null) continue;
            ((TensorImpl)object).zzc();
            this.zzj[n] = null;
        }
        NativeInterpreterWrapper.delete(this.zza, this.zzd, this.zzb);
        NativeInterpreterWrapper.deleteCancellationFlag(this.zze);
        this.zza = 0L;
        this.zzd = 0L;
        this.zzb = 0L;
        this.zze = 0L;
        this.zzf = null;
        this.zzg = null;
        this.zzh = null;
        this.zzk = false;
        this.zzl.clear();
        Iterator iterator = this.zzm.iterator();
        while (iterator.hasNext()) {
            ((Delegate)iterator.next()).close();
        }
        this.zzm.clear();
    }

    private static native void delete(long var0, long var2, long var4);

    private static native void run(long var0, long var2);

    private static native boolean hasUnresolvedFlexOp(long var0);

    private static native boolean resizeInput(long var0, long var2, int var4, int[] var5, boolean var6);

    private static native String[] getInputNames(long var0);

    private static native String[] getOutputNames(long var0);

    final int zza(String string) {
        Serializable serializable;
        Object[] objectArray;
        if (this.zzg == null) {
            objectArray = NativeInterpreterWrapper.getInputNames(this.zzb);
            this.zzg = serializable = new Serializable();
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    this.zzg.put(objectArray[i], i);
                }
            }
        }
        if (!this.zzg.containsKey(string)) {
            objectArray = new Object[]{string, this.zzg};
            serializable = new Serializable(String.format("Input error: '%s' is not a valid name for any input. Names of inputs and their indexes are %s", objectArray));
            throw serializable;
        }
        return (Integer)this.zzg.get(string);
    }

    final int zzb() {
        return this.zzi.length;
    }

    final int zzc(String string) {
        Serializable serializable;
        Object[] objectArray;
        if (this.zzh == null) {
            objectArray = NativeInterpreterWrapper.getOutputNames(this.zzb);
            this.zzh = serializable = new Serializable();
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    this.zzh.put(objectArray[i], i);
                }
            }
        }
        if (!this.zzh.containsKey(string)) {
            objectArray = new Object[]{string, this.zzh};
            serializable = new Serializable(String.format("Input error: '%s' is not a valid name for any output. Names of outputs and their indexes are %s", objectArray));
            throw serializable;
        }
        return (Integer)this.zzh.get(string);
    }

    final int zzd() {
        return this.zzj.length;
    }

    final TensorImpl zze(int n) {
        Object object;
        if (n < 0 || n >= ((TensorImpl[])(object = ((NativeInterpreterWrapper)object2).zzi)).length) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Invalid input Tensor index: ");
            ((StringBuilder)object).append(n);
            Object object2 = new IllegalArgumentException(((StringBuilder)object).toString());
            throw object2;
        }
        Object object3 = object[n];
        if (object3 == null) {
            long l = ((NativeInterpreterWrapper)object2).zzb;
            object[n] = object2 = TensorImpl.zzb(l, NativeInterpreterWrapper.getInputTensorIndex(l, n));
            return object2;
        }
        return object3;
    }

    final TensorImpl zzf(int n) {
        Object object;
        if (n < 0 || n >= ((TensorImpl[])(object = ((NativeInterpreterWrapper)object2).zzj)).length) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Invalid output Tensor index: ");
            ((StringBuilder)object).append(n);
            Object object2 = new IllegalArgumentException(((StringBuilder)object).toString());
            throw object2;
        }
        Object object3 = object[n];
        if (object3 == null) {
            long l = ((NativeInterpreterWrapper)object2).zzb;
            object[n] = object2 = TensorImpl.zzb(l, NativeInterpreterWrapper.getOutputTensorIndex(l, n));
            return object2;
        }
        return object3;
    }

    final Long zzg() {
        long l = this.inferenceDurationNanoseconds;
        if (l < 0L) {
            return null;
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Delegate zzk(List object) {
        try {
            boolean bl;
            Class<?> clazz = Class.forName("com.google.android.gms.tflite.flex.FlexDelegate");
            object = object.iterator();
            do {
                if (bl = object.hasNext()) continue;
                return (Delegate)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            } while (!(bl = clazz.isInstance((Delegate)object.next())));
            return null;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return null;
        }
    }

    NativeInterpreterWrapper(String string, zzc zzc2) {
        ArrayList arrayList;
        this.zze = 0L;
        this.inferenceDurationNanoseconds = -1L;
        this.zzk = false;
        this.zzl = arrayList = new ArrayList();
        this.zzm = arrayList = new ArrayList();
        TensorFlowLite.init();
        long l = NativeInterpreterWrapper.createErrorReporter(512);
        this.zzl(l, NativeInterpreterWrapper.createModel(string, l), zzc2);
    }

    NativeInterpreterWrapper(ByteBuffer byteBuffer, zzc zzc2) {
        ArrayList arrayList;
        ((NativeInterpreterWrapper)object).zze = 0L;
        ((NativeInterpreterWrapper)object).inferenceDurationNanoseconds = -1L;
        ((NativeInterpreterWrapper)object).zzk = false;
        ((NativeInterpreterWrapper)object).zzl = arrayList = new ArrayList();
        ((NativeInterpreterWrapper)object).zzm = arrayList = new ArrayList();
        TensorFlowLite.init();
        if (byteBuffer == null || !(byteBuffer instanceof MappedByteBuffer) && (!byteBuffer.isDirect() || byteBuffer.order() != ByteOrder.nativeOrder())) {
            Object object = new IllegalArgumentException("Model ByteBuffer should be either a MappedByteBuffer of the model file, or a direct ByteBuffer using ByteOrder.nativeOrder() which contains bytes of model content.");
            throw object;
        }
        ((NativeInterpreterWrapper)object).zzf = byteBuffer;
        long l = NativeInterpreterWrapper.createErrorReporter(512);
        super.zzl(l, NativeInterpreterWrapper.createModelWithBuffer(((NativeInterpreterWrapper)object).zzf, l), zzc2);
    }

    final void zzh() {
        this.zzm();
    }

    private final void zzl(long l, long l2, zzc zzc2) {
        block10: {
            Object object;
            long l3;
            if (zzc2 == null) {
                zzc2 = new zzc();
            }
            ((NativeInterpreterWrapper)object).zza = l;
            ((NativeInterpreterWrapper)object).zzd = l2;
            ArrayList<Long> arrayList = new ArrayList<Long>();
            ((NativeInterpreterWrapper)object).zzb = l3 = NativeInterpreterWrapper.createInterpreter(l2, l, zzc2.getNumThreads(), true, arrayList);
            if (NativeInterpreterWrapper.hasUnresolvedFlexOp(l3) && (object = NativeInterpreterWrapper.zzk(zzc2.getDelegates())) != null) {
                ((NativeInterpreterWrapper)object).zzm.add(object);
                ((NativeInterpreterWrapper)object).zzl.add(object);
            }
            for (Object object2 : zzc2.getDelegates()) {
                if (zzc2.getRuntime() == InterpreterApi.Options.TfLiteRuntime.FROM_APPLICATION_ONLY || object2 instanceof NnApiDelegate) {
                    ((NativeInterpreterWrapper)object).zzl.add(object2);
                    continue;
                }
                break block10;
            }
            object = zzc2.getDelegateFactories().iterator();
            while (object.hasNext()) {
                Object object2;
                object2 = ((DelegateFactory)object.next()).create(zzc);
                ((NativeInterpreterWrapper)object).zzm.add(object2);
                ((NativeInterpreterWrapper)object).zzl.add(object2);
            }
            if (zzc2.getUseNNAPI()) {
                object = new NnApiDelegate();
                ((NativeInterpreterWrapper)object).zzm.add(object);
                ((NativeInterpreterWrapper)object).zzl.add(object);
            }
            object = new InterpreterFactoryImpl();
            for (Delegate delegate : ((NativeInterpreterWrapper)object).zzl) {
                if (!(delegate instanceof NnApiDelegate)) continue;
                ((NnApiDelegate)delegate).initWithInterpreterFactoryApi((InterpreterFactoryApi)object);
            }
            arrayList.ensureCapacity(((NativeInterpreterWrapper)object).zzl.size());
            object = ((NativeInterpreterWrapper)object).zzl.iterator();
            while (object.hasNext()) {
                arrayList.add(((Delegate)object.next()).getNativeHandle());
            }
            if (!arrayList.isEmpty()) {
                NativeInterpreterWrapper.delete(0L, 0L, ((NativeInterpreterWrapper)object).zzb);
                ((NativeInterpreterWrapper)object).zzb = NativeInterpreterWrapper.createInterpreter(l2, l, zzc2.getNumThreads(), true, arrayList);
            }
            if (zzc2.isCancellable()) {
                ((NativeInterpreterWrapper)object).zze = NativeInterpreterWrapper.createCancellationFlag(((NativeInterpreterWrapper)object).zzb);
            }
            ((NativeInterpreterWrapper)object).zzi = new TensorImpl[NativeInterpreterWrapper.getInputCount(((NativeInterpreterWrapper)object).zzb)];
            ((NativeInterpreterWrapper)object).zzj = new TensorImpl[NativeInterpreterWrapper.getOutputCount(((NativeInterpreterWrapper)object).zzb)];
            NativeInterpreterWrapper.allocateTensors(((NativeInterpreterWrapper)object).zzb, l);
            ((NativeInterpreterWrapper)object).zzk = true;
            return;
        }
        Object object = new IllegalArgumentException("Instantiated delegates (other than NnApiDelegate) are not allowed when using TF Lite from Google Play Services. Please use InterpreterApi.Options.addDelegateFactory() with an appropriate DelegateFactory instead.");
        throw object;
    }

    final void zzi(int n, int[] nArray, boolean bl) {
        if (NativeInterpreterWrapper.resizeInput(((NativeInterpreterWrapper)((Object)tensorImpl)).zzb, ((NativeInterpreterWrapper)((Object)tensorImpl)).zza, n, nArray, bl)) {
            ((NativeInterpreterWrapper)((Object)tensorImpl)).zzk = false;
            TensorImpl tensorImpl = ((NativeInterpreterWrapper)((Object)tensorImpl)).zzi[n];
            if (tensorImpl != null) {
                tensorImpl.zzf();
                return;
            }
        }
    }

    final void zzj(Object[] object, Map object22) {
        long l;
        Object object3;
        ((NativeInterpreterWrapper)object3).inferenceDurationNanoseconds = -1L;
        if (object == null || ((Object)object).length == 0) {
            object3 = new IllegalArgumentException("Input error: Inputs should not be null or empty.");
            throw object3;
        }
        if (object22 != null) {
            int n;
            for (n = 0; n < ((Object)object).length; ++n) {
                int[] nArray = ((NativeInterpreterWrapper)object3).zze(n).zzh(object[n]);
                if (nArray == null) continue;
                ((NativeInterpreterWrapper)object3).zzi(n, nArray, false);
            }
            int n2 = super.zzm();
            for (n = 0; n < ((Object)object).length; ++n) {
                ((NativeInterpreterWrapper)object3).zze(n).zzg(object[n]);
            }
            long l2 = System.nanoTime();
            NativeInterpreterWrapper.run(((NativeInterpreterWrapper)object3).zzb, ((NativeInterpreterWrapper)object3).zza);
            l = System.nanoTime() - l2;
            if (n2 != 0) {
                for (TensorImpl tensorImpl : ((NativeInterpreterWrapper)object3).zzj) {
                    if (tensorImpl == null) continue;
                    tensorImpl.zzf();
                }
            }
            for (Map.Entry entry : object22.entrySet()) {
                if (entry.getValue() == null) continue;
                ((NativeInterpreterWrapper)object3).zzf((Integer)entry.getKey()).zzd(entry.getValue());
            }
        } else {
            object3 = new IllegalArgumentException("Input error: Outputs should not be null.");
            throw object3;
        }
        ((NativeInterpreterWrapper)object3).inferenceDurationNanoseconds = l;
    }

    private final boolean zzm() {
        if (this.zzk) {
            return false;
        }
        this.zzk = true;
        NativeInterpreterWrapper.allocateTensors(this.zzb, this.zza);
        for (TensorImpl tensorImpl : this.zzj) {
            if (tensorImpl == null) continue;
            tensorImpl.zzf();
        }
        return true;
    }
}

