/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.maps.zzal;
import com.google.android.gms.internal.maps.zzam;
import com.google.android.gms.maps.model.TileProvider;
import com.google.android.gms.maps.model.zzaa;
import com.google.android.gms.maps.model.zzab;
import com.google.android.gms.maps.model.zzac;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="TileOverlayOptionsCreator")
public final class TileOverlayOptions
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<TileOverlayOptions> CREATOR;
    @Nullable
    @SafeParcelable.Field(id=2, getter="getTileProviderDelegate", type="android.os.IBinder")
    private zzam zza;
    @Nullable
    private TileProvider zzb;
    @SafeParcelable.Field(id=3, getter="isVisible")
    private boolean zzc = true;
    @SafeParcelable.Field(id=4, getter="getZIndex")
    private float zzd;
    @SafeParcelable.Field(id=5, getter="getFadeIn", defaultValue="true")
    private boolean zze = true;
    @SafeParcelable.Field(id=6, getter="getTransparency")
    private float zzf = 0.0f;

    public float getTransparency() {
        return this.zzf;
    }

    public float getZIndex() {
        return this.zzd;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public TileOverlayOptions fadeIn(boolean fadeIn) {
        void var1_1;
        this.zze = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public TileOverlayOptions tileProvider(@NonNull TileProvider tileProvider) {
        void var1_1;
        this.zzb = (TileProvider)Preconditions.checkNotNull((Object)var1_1, (Object)"tileProvider must not be null.");
        zzab zzab2 = new zzab(this, (TileProvider)var1_1);
        this.zza = zzab2;
        return this;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NonNull
    public TileOverlayOptions transparency(float transparency) {
        void var1_1;
        boolean bl = transparency >= 0.0f ? var1_1 <= 1.0f : false;
        Preconditions.checkArgument((boolean)bl, (Object)"Transparency must be in the range [0..1]");
        this.zzf = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public TileOverlayOptions visible(boolean visible) {
        void var1_1;
        this.zzc = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public TileOverlayOptions zIndex(float zIndex) {
        void var1_1;
        this.zzd = var1_1;
        return this;
    }

    @Nullable
    public TileProvider getTileProvider() {
        return this.zzb;
    }

    static {
        zzac zzac2;
        CREATOR = zzac2 = new zzac();
    }

    public TileOverlayOptions() {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    TileOverlayOptions(@SafeParcelable.Param(id=2) IBinder object, @SafeParcelable.Param(id=3) boolean bl, @SafeParcelable.Param(id=4) float f, @SafeParcelable.Param(id=5) boolean bl2, @SafeParcelable.Param(id=6) float f2) {
        void var5_8;
        void var4_7;
        void var3_6;
        void var2_5;
        void var1_3;
        this.zza = zzal.zzc(object);
        if (this.zza == null) {
            Object var1_2 = null;
        } else {
            zzaa zzaa2 = new zzaa(this);
        }
        this.zzb = var1_3;
        this.zzc = var2_5;
        this.zzd = var3_6;
        this.zze = var4_7;
        this.zzf = var5_8;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)out);
        zzam zzam2 = this.zza;
        zzam2 = zzam2 == null ? null : zzam2.asBinder();
        SafeParcelWriter.writeIBinder((Parcel)var1_1, (int)2, (IBinder)zzam2, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)3, (boolean)this.isVisible());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)4, (float)this.getZIndex());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)5, (boolean)this.getFadeIn());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)6, (float)this.getTransparency());
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n2);
    }

    public boolean getFadeIn() {
        return this.zze;
    }

    public boolean isVisible() {
        return this.zzc;
    }

    static /* bridge */ /* synthetic */ zzam zza(TileOverlayOptions tileOverlayOptions) {
        return tileOverlayOptions.zza;
    }
}

