/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zzi;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="MarkerOptionsCreator")
public final class MarkerOptions
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<MarkerOptions> CREATOR;
    @SafeParcelable.Field(id=2, getter="getPosition")
    private LatLng zza;
    @SafeParcelable.Field(id=3, getter="getTitle")
    @Nullable
    private String zzb;
    @SafeParcelable.Field(id=4, getter="getSnippet")
    @Nullable
    private String zzc;
    @SafeParcelable.Field(id=5, getter="getWrappedIconDescriptorImplBinder", type="android.os.IBinder")
    @Nullable
    private BitmapDescriptor zzd;
    @SafeParcelable.Field(id=6, getter="getAnchorU")
    private float zze = 0.5f;
    @SafeParcelable.Field(id=7, getter="getAnchorV")
    private float zzf = 1.0f;
    @SafeParcelable.Field(id=8, getter="isDraggable")
    private boolean zzg;
    @SafeParcelable.Field(id=9, getter="isVisible")
    private boolean zzh = true;
    @SafeParcelable.Field(id=10, getter="isFlat")
    private boolean zzi = false;
    @SafeParcelable.Field(id=11, getter="getRotation")
    private float zzj = 0.0f;
    @SafeParcelable.Field(id=12, getter="getInfoWindowAnchorU", defaultValue="0.5f")
    private float zzk = 0.5f;
    @SafeParcelable.Field(id=13, getter="getInfoWindowAnchorV")
    private float zzl = 0.0f;
    @SafeParcelable.Field(id=14, getter="getAlpha", defaultValue="1.0f")
    private float zzm = 1.0f;
    @SafeParcelable.Field(id=15, getter="getZIndex")
    private float zzn;

    public float getAlpha() {
        return this.zzm;
    }

    public float getAnchorU() {
        return this.zze;
    }

    public float getAnchorV() {
        return this.zzf;
    }

    public float getInfoWindowAnchorU() {
        return this.zzk;
    }

    public float getInfoWindowAnchorV() {
        return this.zzl;
    }

    public float getRotation() {
        return this.zzj;
    }

    public float getZIndex() {
        return this.zzn;
    }

    @Nullable
    public BitmapDescriptor getIcon() {
        return this.zzd;
    }

    @NonNull
    public LatLng getPosition() {
        return this.zza;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public MarkerOptions alpha(float alpha) {
        void var1_1;
        this.zzm = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public MarkerOptions anchor(float u, float v) {
        void var2_2;
        void var1_1;
        this.zze = var1_1;
        this.zzf = var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public MarkerOptions draggable(boolean draggable) {
        void var1_1;
        this.zzg = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public MarkerOptions flat(boolean flat) {
        void var1_1;
        this.zzi = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public MarkerOptions icon(@Nullable BitmapDescriptor iconDescriptor) {
        void var1_1;
        this.zzd = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public MarkerOptions infoWindowAnchor(float u, float v) {
        void var2_2;
        void var1_1;
        this.zzk = var1_1;
        this.zzl = var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public MarkerOptions position(@NonNull LatLng latlng) {
        void var1_1;
        if (latlng == null) {
            Object object = new IllegalArgumentException("latlng cannot be null - a position is required.");
            throw object;
        }
        object.zza = var1_1;
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public MarkerOptions rotation(float rotation) {
        void var1_1;
        this.zzj = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public MarkerOptions snippet(@Nullable String snippet) {
        void var1_1;
        this.zzc = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public MarkerOptions title(@Nullable String title) {
        void var1_1;
        this.zzb = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public MarkerOptions visible(boolean visible) {
        void var1_1;
        this.zzh = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public MarkerOptions zIndex(float zIndex) {
        void var1_1;
        this.zzn = var1_1;
        return this;
    }

    @Nullable
    public String getSnippet() {
        return this.zzc;
    }

    @Nullable
    public String getTitle() {
        return this.zzb;
    }

    static {
        zzi zzi2;
        CREATOR = zzi2 = new zzi();
    }

    public MarkerOptions() {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    MarkerOptions(@SafeParcelable.Param(id=2) LatLng object, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) String string2, @SafeParcelable.Param(id=5) @Nullable IBinder iBinder, @SafeParcelable.Param(id=6) float f, @SafeParcelable.Param(id=7) float f2, @SafeParcelable.Param(id=8) boolean bl, @SafeParcelable.Param(id=9) boolean bl2, @SafeParcelable.Param(id=10) boolean bl3, @SafeParcelable.Param(id=11) float f3, @SafeParcelable.Param(id=12) float f4, @SafeParcelable.Param(id=13) float f5, @SafeParcelable.Param(id=14) float f6, @SafeParcelable.Param(id=15) float f7) {
        void var14_15;
        void var13_14;
        void var12_13;
        void var11_12;
        void var10_11;
        void var9_10;
        void var8_9;
        void var7_8;
        void var6_7;
        void var5_6;
        BitmapDescriptor bitmapDescriptor;
        void var4_5;
        void var3_4;
        void var2_3;
        this.zza = object;
        this.zzb = var2_3;
        this.zzc = var3_4;
        this.zzd = var4_5 == null ? null : (bitmapDescriptor = new BitmapDescriptor(IObjectWrapper.Stub.asInterface((IBinder)var4_5)));
        this.zze = var5_6;
        this.zzf = var6_7;
        this.zzg = var7_8;
        this.zzh = var8_9;
        this.zzi = var9_10;
        this.zzj = var10_11;
        this.zzk = var11_12;
        this.zzl = var12_13;
        this.zzm = var13_14;
        this.zzn = var14_15;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)2, (Parcelable)this.getPosition(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.getTitle(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)4, (String)this.getSnippet(), (boolean)false);
        BitmapDescriptor bitmapDescriptor = this.zzd;
        bitmapDescriptor = bitmapDescriptor == null ? null : bitmapDescriptor.zza().asBinder();
        SafeParcelWriter.writeIBinder((Parcel)var1_1, (int)5, (IBinder)bitmapDescriptor, (boolean)false);
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)6, (float)this.getAnchorU());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)7, (float)this.getAnchorV());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)8, (boolean)this.isDraggable());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)9, (boolean)this.isVisible());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)10, (boolean)this.isFlat());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)11, (float)this.getRotation());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)12, (float)this.getInfoWindowAnchorU());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)13, (float)this.getInfoWindowAnchorV());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)14, (float)this.getAlpha());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)15, (float)this.getZIndex());
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean isDraggable() {
        return this.zzg;
    }

    public boolean isFlat() {
        return this.zzi;
    }

    public boolean isVisible() {
        return this.zzh;
    }
}

