/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.zzd;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="GroundOverlayOptionsCreator")
public final class GroundOverlayOptions
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<GroundOverlayOptions> CREATOR;
    public static final float NO_DIMENSION = -1.0f;
    @SafeParcelable.Field(id=2, getter="getWrappedImageDescriptorImplBinder", type="android.os.IBinder")
    private BitmapDescriptor zza;
    @SafeParcelable.Field(id=3, getter="getLocation")
    @Nullable
    private LatLng zzb;
    @SafeParcelable.Field(id=4, getter="getWidth")
    private float zzc;
    @SafeParcelable.Field(id=5, getter="getHeight")
    private float zzd;
    @SafeParcelable.Field(id=6, getter="getBounds")
    @Nullable
    private LatLngBounds zze;
    @SafeParcelable.Field(id=7, getter="getBearing")
    private float zzf;
    @SafeParcelable.Field(id=8, getter="getZIndex")
    private float zzg;
    @SafeParcelable.Field(id=9, getter="isVisible")
    private boolean zzh = true;
    @SafeParcelable.Field(id=10, getter="getTransparency")
    private float zzi = 0.0f;
    @SafeParcelable.Field(id=11, getter="getAnchorU")
    private float zzj = 0.5f;
    @SafeParcelable.Field(id=12, getter="getAnchorV")
    private float zzk = 0.5f;
    @SafeParcelable.Field(id=13, getter="isClickable")
    private boolean zzl = false;

    public float getAnchorU() {
        return this.zzj;
    }

    public float getAnchorV() {
        return this.zzk;
    }

    public float getBearing() {
        return this.zzf;
    }

    public float getHeight() {
        return this.zzd;
    }

    public float getTransparency() {
        return this.zzi;
    }

    public float getWidth() {
        return this.zzc;
    }

    public float getZIndex() {
        return this.zzg;
    }

    @NonNull
    public BitmapDescriptor getImage() {
        return this.zza;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public GroundOverlayOptions anchor(float u, float v) {
        void var2_2;
        void var1_1;
        this.zzj = var1_1;
        this.zzk = var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public GroundOverlayOptions bearing(float bearing) {
        void var1_1;
        this.zzf = (var1_1 % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public GroundOverlayOptions clickable(boolean clickable) {
        void var1_1;
        this.zzl = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public GroundOverlayOptions image(@NonNull BitmapDescriptor imageDescriptor) {
        void var1_1;
        Preconditions.checkNotNull((Object)imageDescriptor, (Object)"imageDescriptor must not be null");
        this.zza = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NonNull
    public GroundOverlayOptions position(@NonNull LatLng location, float width) {
        void var2_2;
        void var1_1;
        boolean bl = this.zze == null;
        Preconditions.checkState((boolean)bl, (Object)"Position has already been set using positionFromBounds");
        bl = var1_1 != null;
        Preconditions.checkArgument((boolean)bl, (Object)"Location must be specified");
        bl = var2_2 >= 0.0f;
        Preconditions.checkArgument((boolean)bl, (Object)"Width must be non-negative");
        this.zza((LatLng)var1_1, (float)var2_2, -1.0f);
        return this;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NonNull
    public GroundOverlayOptions position(@NonNull LatLng location, float width, float height) {
        void var3_3;
        void var2_2;
        void var1_1;
        boolean bl = this.zze == null;
        Preconditions.checkState((boolean)bl, (Object)"Position has already been set using positionFromBounds");
        bl = var1_1 != null;
        Preconditions.checkArgument((boolean)bl, (Object)"Location must be specified");
        bl = var2_2 >= 0.0f;
        Preconditions.checkArgument((boolean)bl, (Object)"Width must be non-negative");
        bl = var3_3 >= 0.0f;
        Preconditions.checkArgument((boolean)bl, (Object)"Height must be non-negative");
        this.zza((LatLng)var1_1, (float)var2_2, (float)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NonNull
    public GroundOverlayOptions positionFromBounds(@NonNull LatLngBounds bounds) {
        void var1_1;
        LatLng latLng = this.zzb;
        boolean bl = latLng == null;
        Preconditions.checkState((boolean)bl, (Object)"Position has already been set using position: ".concat(String.valueOf(String.valueOf((Object)latLng))));
        this.zze = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NonNull
    public GroundOverlayOptions transparency(float transparency) {
        void var1_1;
        boolean bl = transparency >= 0.0f ? var1_1 <= 1.0f : false;
        Preconditions.checkArgument((boolean)bl, (Object)"Transparency must be in the range [0..1]");
        this.zzi = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public GroundOverlayOptions visible(boolean visible) {
        void var1_1;
        this.zzh = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public GroundOverlayOptions zIndex(float zIndex) {
        void var1_1;
        this.zzg = var1_1;
        return this;
    }

    @Nullable
    public LatLng getLocation() {
        return this.zzb;
    }

    @Nullable
    public LatLngBounds getBounds() {
        return this.zze;
    }

    static {
        zzd zzd2;
        CREATOR = zzd2 = new zzd();
    }

    public GroundOverlayOptions() {
    }

    @SafeParcelable.Constructor
    GroundOverlayOptions(@SafeParcelable.Param(id=2) IBinder iBinder, @SafeParcelable.Param(id=3) LatLng latLng, @SafeParcelable.Param(id=4) float f, @SafeParcelable.Param(id=5) float f2, @SafeParcelable.Param(id=6) LatLngBounds latLngBounds, @SafeParcelable.Param(id=7) float f3, @SafeParcelable.Param(id=8) float f4, @SafeParcelable.Param(id=9) boolean bl, @SafeParcelable.Param(id=10) float f5, @SafeParcelable.Param(id=11) float f6, @SafeParcelable.Param(id=12) float f7, @SafeParcelable.Param(id=13) boolean bl2) {
        BitmapDescriptor bitmapDescriptor;
        this.zza = bitmapDescriptor = new BitmapDescriptor(IObjectWrapper.Stub.asInterface((IBinder)iBinder));
        this.zzb = latLng;
        this.zzc = f;
        this.zzd = f2;
        this.zze = latLngBounds;
        this.zzf = f3;
        this.zzg = f4;
        this.zzh = bl;
        this.zzi = f5;
        this.zzj = f6;
        this.zzk = f7;
        this.zzl = bl2;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeIBinder((Parcel)var1_1, (int)2, (IBinder)this.zza.zza().asBinder(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)3, (Parcelable)this.getLocation(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)4, (float)this.getWidth());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)5, (float)this.getHeight());
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)6, (Parcelable)this.getBounds(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)7, (float)this.getBearing());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)8, (float)this.getZIndex());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)9, (boolean)this.isVisible());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)10, (float)this.getTransparency());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)11, (float)this.getAnchorU());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)12, (float)this.getAnchorV());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)13, (boolean)this.isClickable());
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean isClickable() {
        return this.zzl;
    }

    public boolean isVisible() {
        return this.zzh;
    }

    private final GroundOverlayOptions zza(LatLng latLng, float f, float f2) {
        this.zzb = latLng;
        this.zzc = f;
        this.zzd = f2;
        return this;
    }
}

