/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.zzd;

public final class GroundOverlayOptions
extends zzbgl {
    @Hide
    public static final Parcelable.Creator<GroundOverlayOptions> CREATOR = new zzd();
    public static final float NO_DIMENSION = -1.0f;
    @NonNull
    private BitmapDescriptor zza;
    private LatLng zzb;
    private float zzc;
    private float zzd;
    private LatLngBounds zze;
    private float zzf;
    private float zzg;
    private boolean zzh = true;
    private float zzi = 0.0f;
    private float zzj = 0.5f;
    private float zzk = 0.5f;
    private boolean zzl = false;

    @Hide
    GroundOverlayOptions(IBinder iBinder, LatLng latLng, float f, float f2, LatLngBounds latLngBounds, float f3, float f4, boolean bl, float f5, float f6, float f7, boolean bl2) {
        this.zza = new BitmapDescriptor(IObjectWrapper.zza.zza((IBinder)iBinder));
        this.zzb = latLng;
        this.zzc = f;
        this.zzd = f2;
        this.zze = latLngBounds;
        this.zzf = f3;
        this.zzg = f4;
        this.zzh = bl;
        this.zzi = f5;
        this.zzj = f6;
        this.zzk = f7;
        this.zzl = bl2;
    }

    public GroundOverlayOptions() {
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GroundOverlayOptions groundOverlayOptions = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (IBinder)groundOverlayOptions.zza.zza().asBinder(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (Parcelable)groundOverlayOptions.getLocation(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (float)groundOverlayOptions.getWidth());
        zzbgo.zza((Parcel)parcel2, (int)5, (float)groundOverlayOptions.getHeight());
        zzbgo.zza((Parcel)parcel2, (int)6, (Parcelable)groundOverlayOptions.getBounds(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (float)groundOverlayOptions.getBearing());
        zzbgo.zza((Parcel)parcel2, (int)8, (float)groundOverlayOptions.getZIndex());
        zzbgo.zza((Parcel)parcel2, (int)9, (boolean)groundOverlayOptions.isVisible());
        zzbgo.zza((Parcel)parcel2, (int)10, (float)groundOverlayOptions.getTransparency());
        zzbgo.zza((Parcel)parcel2, (int)11, (float)groundOverlayOptions.getAnchorU());
        zzbgo.zza((Parcel)parcel2, (int)12, (float)groundOverlayOptions.getAnchorV());
        zzbgo.zza((Parcel)parcel2, (int)13, (boolean)groundOverlayOptions.isClickable());
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public final GroundOverlayOptions image(@NonNull BitmapDescriptor bitmapDescriptor) {
        zzbq.zza((Object)bitmapDescriptor, (Object)"imageDescriptor must not be null");
        this.zza = bitmapDescriptor;
        return this;
    }

    public final GroundOverlayOptions anchor(float f, float f2) {
        this.zzj = f;
        this.zzk = f2;
        return this;
    }

    public final GroundOverlayOptions position(LatLng latLng, float f) {
        zzbq.zza((this.zze == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzbq.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzbq.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        return this.zza(latLng, f, -1.0f);
    }

    public final GroundOverlayOptions position(LatLng latLng, float f, float f2) {
        zzbq.zza((this.zze == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzbq.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzbq.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        zzbq.zzb((f2 >= 0.0f ? 1 : 0) != 0, (Object)"Height must be non-negative");
        return this.zza(latLng, f, f2);
    }

    private final GroundOverlayOptions zza(LatLng latLng, float f, float f2) {
        this.zzb = latLng;
        this.zzc = f;
        this.zzd = f2;
        return this;
    }

    public final GroundOverlayOptions positionFromBounds(LatLngBounds latLngBounds) {
        String string = String.valueOf((Object)this.zzb);
        zzbq.zza((this.zzb == null ? 1 : 0) != 0, (Object)new StringBuilder(46 + String.valueOf(string).length()).append("Position has already been set using position: ").append(string).toString());
        this.zze = latLngBounds;
        return this;
    }

    public final GroundOverlayOptions bearing(float f) {
        this.zzf = (f % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public final GroundOverlayOptions zIndex(float f) {
        this.zzg = f;
        return this;
    }

    public final GroundOverlayOptions visible(boolean bl) {
        this.zzh = bl;
        return this;
    }

    public final GroundOverlayOptions transparency(float f) {
        zzbq.zzb((f >= 0.0f && f <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.zzi = f;
        return this;
    }

    public final GroundOverlayOptions clickable(boolean bl) {
        this.zzl = bl;
        return this;
    }

    public final BitmapDescriptor getImage() {
        return this.zza;
    }

    public final LatLng getLocation() {
        return this.zzb;
    }

    public final float getWidth() {
        return this.zzc;
    }

    public final float getHeight() {
        return this.zzd;
    }

    public final LatLngBounds getBounds() {
        return this.zze;
    }

    public final float getBearing() {
        return this.zzf;
    }

    public final float getZIndex() {
        return this.zzg;
    }

    public final float getTransparency() {
        return this.zzi;
    }

    public final float getAnchorU() {
        return this.zzj;
    }

    public final float getAnchorV() {
        return this.zzk;
    }

    public final boolean isVisible() {
        return this.zzh;
    }

    public final boolean isClickable() {
        return this.zzl;
    }
}

